/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.flow.parallel.strategy;

import com.yomahub.liteflow.flow.element.condition.WhenCondition;
import com.yomahub.liteflow.flow.parallel.WhenFutureObj;
import com.yomahub.liteflow.flow.parallel.strategy.ParallelStrategyExecutor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.LongAdder;

public class PercentageOfParallelExecutor
extends ParallelStrategyExecutor {
    @Override
    public void execute(WhenCondition whenCondition, Integer slotIndex) throws Exception {
        List<CompletableFuture<WhenFutureObj>> whenAllTaskList = this.getWhenAllTaskList(whenCondition, slotIndex);
        int total = whenAllTaskList.size();
        int thresholdCount = Math.max(1, (int)Math.ceil((double)total * whenCondition.getPercentage()));
        ConcurrentLinkedQueue completedFutures = new ConcurrentLinkedQueue();
        CompletableFuture thresholdFuture = new CompletableFuture();
        LongAdder completedCount = new LongAdder();
        whenAllTaskList.forEach(future -> future.whenComplete((result, ex) -> {
            completedCount.increment();
            int currentCount = completedCount.intValue();
            if (currentCount <= thresholdCount) {
                completedFutures.add(future);
            }
            if (currentCount >= thresholdCount && !thresholdFuture.isDone()) {
                thresholdFuture.complete(null);
            }
        }));
        CompletionStage combinedTask = thresholdFuture.thenRun(() -> CompletableFuture.allOf(completedFutures.toArray(new CompletableFuture[0])).join());
        this.handleTaskResult(whenCondition, slotIndex, whenAllTaskList, (CompletableFuture<?>)combinedTask);
    }
}

