/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.script;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.yomahub.liteflow.enums.ScriptTypeEnum;
import com.yomahub.liteflow.exception.LiteFlowException;
import com.yomahub.liteflow.lifecycle.LifeCycleHolder;
import com.yomahub.liteflow.script.ScriptBeanManager;
import com.yomahub.liteflow.script.ScriptExecuteWrap;
import com.yomahub.liteflow.slot.DataBus;
import com.yomahub.liteflow.slot.Slot;
import com.yomahub.liteflow.spi.holder.CmpAroundAspectHolder;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class ScriptExecutor {
    public ScriptExecutor init() {
        this.lifeCycle(null);
        return this;
    }

    public void lifeCycle(Object engine) {
        if (CollUtil.isNotEmpty(LifeCycleHolder.getPostProcessScriptEngineInitLifeCycleList())) {
            LifeCycleHolder.getPostProcessScriptEngineInitLifeCycleList().forEach(postProcessAfterScriptEngineInitLifeCycle -> postProcessAfterScriptEngineInitLifeCycle.postProcessAfterScriptEngineInit(engine));
        }
    }

    public abstract void load(String var1, String var2);

    public abstract void unLoad(String var1);

    public abstract List<String> getNodeIds();

    public Object execute(ScriptExecuteWrap wrap) throws Exception {
        try {
            return this.executeScript(wrap);
        }
        catch (Exception e) {
            if (ObjectUtil.isNotNull((Object)e.getCause()) && e.getCause() instanceof LiteFlowException) {
                throw (LiteFlowException)e.getCause();
            }
            if (ObjectUtil.isNotNull((Object)e.getCause()) && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    public abstract Object executeScript(ScriptExecuteWrap var1) throws Exception;

    public abstract void cleanCache();

    public abstract ScriptTypeEnum scriptType();

    public void bindParam(ScriptExecuteWrap wrap, BiConsumer<String, Object> putConsumer, BiConsumer<String, Object> putIfAbsentConsumer) {
        DataBus.getContextBeanList(wrap.getSlotIndex()).forEach(tuple -> putConsumer.accept((String)tuple.get(0), tuple.get(1)));
        Map metaMap = BeanUtil.beanToMap((Object)wrap, (String[])new String[0]);
        Slot slot = DataBus.getSlot(wrap.getSlotIndex());
        metaMap.put("requestData", wrap.cmp.getRequestData());
        Object subRequestData = slot.getChainReqData(wrap.getCurrChainId());
        if (ObjectUtil.isNotNull(subRequestData)) {
            metaMap.put("subRequestData", subRequestData);
        }
        putConsumer.accept("_meta", metaMap);
        ScriptBeanManager.getScriptBeanMap().forEach(putIfAbsentConsumer);
    }

    public abstract Object compile(String var1) throws Exception;

    public boolean executeIsAccess(ScriptExecuteWrap wrap) {
        return true;
    }

    public boolean executeIsContinueOnError(ScriptExecuteWrap wrap) {
        return false;
    }

    public boolean executeIsEnd(ScriptExecuteWrap wrap) {
        return false;
    }

    public void executeBeforeProcess(ScriptExecuteWrap wrap) {
        CmpAroundAspectHolder.loadCmpAroundAspect().beforeProcess(wrap.getCmp());
    }

    public void executeAfterProcess(ScriptExecuteWrap wrap) {
        CmpAroundAspectHolder.loadCmpAroundAspect().afterProcess(wrap.getCmp());
    }

    public void executeOnSuccess(ScriptExecuteWrap wrap) throws Exception {
        CmpAroundAspectHolder.loadCmpAroundAspect().onSuccess(wrap.getCmp());
    }

    public void executeOnError(ScriptExecuteWrap wrap, Exception e) throws Exception {
        CmpAroundAspectHolder.loadCmpAroundAspect().onError(wrap.getCmp(), e);
    }

    public void executeRollback(ScriptExecuteWrap wrap) throws Exception {
    }
}

