/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.parser.sql.util;

import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.parser.sql.datasource.LiteFlowDataSourceConnect;
import com.yomahub.liteflow.parser.sql.datasource.LiteflowDataSourceConnectFactory;
import com.yomahub.liteflow.parser.sql.exception.ELSQLException;
import com.yomahub.liteflow.parser.sql.vo.SQLParserVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteFlowJdbcUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LiteFlowJdbcUtil.class);
    private static final String CHECK_SQL_PATTERN = "SELECT {},{} FROM {}";

    public static Connection getConn(SQLParserVO sqlParserVO) {
        Connection connection = null;
        try {
            Optional<LiteFlowDataSourceConnect> connectOpt = LiteflowDataSourceConnectFactory.getConnect(sqlParserVO);
            if (!connectOpt.isPresent()) {
                throw new ELSQLException("can not found connect by liteflow config");
            }
            connection = connectOpt.get().getConn(sqlParserVO);
        }
        catch (Exception e) {
            throw new ELSQLException(e);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConnectionCanExecuteSql(Connection conn, String sql) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql, 1003, 1007);
            stmt.setFetchSize(1);
            rs = stmt.executeQuery();
            boolean bl = true;
            LiteFlowJdbcUtil.close(conn, stmt, rs);
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            LiteFlowJdbcUtil.close(conn, stmt, rs);
        }
    }

    public static void close(Connection conn, PreparedStatement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
    }

    public static String buildCheckSql(SQLParserVO sqlParserVO) {
        String chainTableName = sqlParserVO.getChainTableName();
        String elDataField = sqlParserVO.getElDataField();
        String chainNameField = sqlParserVO.getChainNameField();
        return StrUtil.format((CharSequence)CHECK_SQL_PATTERN, (Object[])new Object[]{chainNameField, elDataField, chainTableName});
    }

    public static void close(Connection conn, Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new ELSQLException(e);
            }
        }
    }

    public static class DataSourceBeanNameHolder {
        private static String DATA_SOURCE_NAME = null;

        public static synchronized void init(String dataSourceName) {
            if (DATA_SOURCE_NAME == null) {
                DATA_SOURCE_NAME = dataSourceName;
            }
        }

        public static String getDataSourceName() {
            return DATA_SOURCE_NAME;
        }

        public static boolean isNotInit() {
            return DATA_SOURCE_NAME == null;
        }
    }
}

