/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.spi.spring;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.liteflow.exception.ConfigErrorException;
import com.yomahub.liteflow.spi.PathContentParser;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class SpringPathContentParser
implements PathContentParser {
    public List<String> parseContent(List<String> pathList) throws Exception {
        if (CollectionUtil.isEmpty(pathList)) {
            throw new ConfigErrorException("rule source must not be null");
        }
        ArrayList allResource = new ArrayList();
        Iterator<String> iterator = pathList.iterator();
        while (iterator.hasNext()) {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            String path = iterator.next();
            String locationPattern = FileUtil.isAbsolutePath((String)path) && FileUtil.isFile((String)path) ? "file:" + path : (!path.startsWith("classpath:") ? "classpath:" + path : path);
            Object[] resources = resolver.getResources(locationPattern);
            if (ArrayUtil.isEmpty((Object[])resources)) {
                throw new ConfigErrorException("config error,please check rule source property");
            }
            allResource.addAll(ListUtil.toList((Object[])resources));
        }
        HashSet fileTypeSet = new HashSet();
        allResource.forEach(resource -> fileTypeSet.add(FileUtil.extName((String)resource.getFilename())));
        if (fileTypeSet.size() != 1) {
            throw new ConfigErrorException("config error,please use the same type of configuration");
        }
        ArrayList<String> contentList = new ArrayList<String>();
        for (Resource resource2 : allResource) {
            String content = IoUtil.read((InputStream)resource2.getInputStream(), (Charset)CharsetUtil.CHARSET_UTF_8);
            if (!StrUtil.isNotBlank((CharSequence)content)) continue;
            contentList.add(content);
        }
        return contentList;
    }

    public int priority() {
        return 1;
    }
}

