/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.id.snowflake;

import cn.hutool.core.lang.Assert;
import com.yomahub.tlog.id.snowflake.AbstractClock;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(UniqueIdGenerator.class);
    public static final long EPOCH;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORKER_ID_LEFT_SHIFT_BITS = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT_BITS = 22L;
    private static final long WORKER_ID_MAX_VALUE = 1024L;
    private static AbstractClock clock;
    private static String idPrefix;
    private static long workerId;
    private static long sequence;
    private static long lastTime;

    static void initWorkerId() {
        InetAddress address = UniqueIdGenerator.getLocalAddress();
        byte[] ipAddressByteArray = address.getAddress();
        UniqueIdGenerator.setWorkerId(Long.valueOf(((ipAddressByteArray[ipAddressByteArray.length - 2] & 3) << 8) + (ipAddressByteArray[ipAddressByteArray.length - 1] & 0xFF)));
    }

    private static InetAddress getLocalAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses;
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp() || !(addresses = networkInterface.getInetAddresses()).hasMoreElements()) continue;
                return addresses.nextElement();
            }
        }
        catch (Exception e) {
            log.debug("Error when getting host ip address: <{}>.", (Object)e.getMessage());
            throw new IllegalStateException("Cannot get LocalHost InetAddress, please check your network!");
        }
        return null;
    }

    public static void setIdPrefix(String idPrefix) {
        UniqueIdGenerator.idPrefix = (String)StringUtils.defaultIfBlank((CharSequence)idPrefix, (CharSequence)"");
    }

    public static void setWorkerId(Long workerId) {
        Assert.isTrue((workerId >= 0L && workerId < 1024L ? 1 : 0) != 0);
        UniqueIdGenerator.workerId = workerId;
    }

    public static synchronized long generateId() {
        long time = clock.millis();
        Assert.isTrue((lastTime <= time ? 1 : 0) != 0, (String)"Clock is moving backwards, last time is {} milliseconds, current time is {} milliseconds", (Object[])new Object[]{lastTime, time});
        if (lastTime == time) {
            ++sequence;
            if (0L == (sequence &= 0xFFFL)) {
                time = UniqueIdGenerator.waitUntilNextTime(time);
            }
        } else {
            sequence = 0L;
        }
        lastTime = time;
        if (log.isDebugEnabled()) {
            log.debug("{}-{}-{}", new Object[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(lastTime)), workerId, sequence});
        }
        return time - EPOCH << 22 | workerId << 12 | sequence;
    }

    public static String generateStringId() {
        return idPrefix + UniqueIdGenerator.generateId();
    }

    private static long waitUntilNextTime(long lastTime) {
        long time = clock.millis();
        while (time <= lastTime) {
            time = clock.millis();
        }
        return time;
    }

    static {
        clock = AbstractClock.systemClock();
        idPrefix = RandomStringUtils.randomNumeric((int)4);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2017, 3, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        EPOCH = calendar.getTimeInMillis();
        UniqueIdGenerator.initWorkerId();
    }
}

