/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.spring;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.context.TLogLabelGenerator;
import com.yomahub.tlog.id.TLogIdGenerator;
import com.yomahub.tlog.id.TLogIdGeneratorLoader;
import com.yomahub.tlog.spring.TLogSpringAware;
import org.springframework.beans.factory.InitializingBean;

public class TLogPropertyInit
implements InitializingBean {
    private String pattern;
    private Boolean enableInvokeTimePrint;
    private String idGenerator;
    private Boolean mdcEnable;

    public void afterPropertiesSet() throws Exception {
        if (StrUtil.isNotBlank((CharSequence)this.pattern)) {
            TLogLabelGenerator.setLabelPattern(this.pattern);
        }
        if (ObjectUtil.isNotNull((Object)this.enableInvokeTimePrint)) {
            TLogContext.setEnableInvokeTimePrint(this.enableInvokeTimePrint);
        }
        if (StrUtil.isNotBlank((CharSequence)this.idGenerator)) {
            try {
                TLogIdGenerator tLogIdGenerator = (TLogIdGenerator)TLogSpringAware.registerBean(Class.forName(this.idGenerator));
                TLogIdGeneratorLoader.setIdGenerator(tLogIdGenerator);
            }
            catch (Exception e) {
                throw new RuntimeException("Id\u751f\u6210\u5668\u5305\u8def\u5f84\u4e0d\u6b63\u786e");
            }
        }
        if (BooleanUtil.isTrue((Boolean)this.mdcEnable)) {
            TLogContext.setHasTLogMDC(true);
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Boolean getEnableInvokeTimePrint() {
        return this.enableInvokeTimePrint;
    }

    public void setEnableInvokeTimePrint(Boolean enableInvokeTimePrint) {
        this.enableInvokeTimePrint = enableInvokeTimePrint;
    }

    public String getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(String idGenerator) {
        this.idGenerator = idGenerator;
    }

    public Boolean getMdcEnable() {
        return this.mdcEnable;
    }

    public void setMdcEnable(Boolean mdcEnable) {
        this.mdcEnable = mdcEnable;
    }
}

