/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.resttemplate;

import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.context.TLogContext;
import com.yomahub.tlog.spring.TLogSpringAware;
import com.yomahub.tlog.utils.LocalhostUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TLogRestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String traceId = TLogContext.getTraceId();
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            String appName = TLogSpringAware.getProperty((String)"spring.application.name");
            request.getHeaders().add("tlogTraceId", traceId);
            request.getHeaders().add("tlogSpanId", SpanIdGenerator.generateNextSpanId());
            request.getHeaders().add("preIvkApp", appName);
            request.getHeaders().add("preIvkHost", LocalhostUtil.getHostName());
            request.getHeaders().add("preIp", LocalhostUtil.getHostIp());
        } else {
            this.log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        }
        return execution.execute(request, body);
    }
}

