/*
 * Decompiled with CFR 0.152.
 */
package com.openapi.sdk.service;

import com.openapi.sdk.exception.RequestLimitExceededException;
import com.openapi.sdk.exception.UnauthorizedException;
import com.openapi.sdk.sign.HS256Util;
import com.openapi.sdk.sign.SignCommonUtil;
import com.openapi.sdk.util.HttpsUtils;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class DataExchangeService {
    private static final String ACCESS_METHOD_GET = "GET";
    private static final String ACCESS_METHOD_POST = "POST";
    private int CONNECT_TIMEOUT = 120000;
    private int READ_TIMEOUT = 120000;
    protected static final Logger log = Logger.getLogger("com.openapi.sdk.service.DataExchangeService");

    public DataExchangeService(int connectTimeout, int readTimeout) throws RequestLimitExceededException, UnauthorizedException, IllegalArgumentException, Exception {
        this.CONNECT_TIMEOUT = connectTimeout > 0 ? connectTimeout : 120000;
        this.READ_TIMEOUT = readTimeout > 0 ? readTimeout : 120000;
    }

    public String accessHttps(String url, String method) throws RequestLimitExceededException, UnauthorizedException, IllegalArgumentException, Exception {
        if (null == url || url.length() == 0 || null == method || method.trim().length() == 0) {
            throw new IllegalArgumentException("url or method is required");
        }
        if (!ACCESS_METHOD_GET.equals(method.toUpperCase()) && !ACCESS_METHOD_POST.equals(method.toUpperCase())) {
            throw new IllegalArgumentException("method is only be POST or GET");
        }
        String res = HttpsUtils.doPost(url, this.CONNECT_TIMEOUT, this.READ_TIMEOUT);
        return res;
    }

    public String postHttpsOld(String url, Map<String, String> param) throws IllegalArgumentException, Exception {
        if (null == url || url.length() == 0 || param == null || param.isEmpty()) {
            throw new IllegalArgumentException("url or method is required");
        }
        String secretKey = param.get("srt");
        if (secretKey == null || "null".equals(secretKey.trim()) || "".equals(secretKey.trim())) {
            throw new IllegalArgumentException("srt is required");
        }
        String clientId = param.get("cid");
        if (clientId == null || "null".equals(clientId.trim()) || "".equals(clientId.trim())) {
            throw new IllegalArgumentException("cid is required");
        }
        if (param.containsKey("path")) {
            this.getFileData(param, "path", "fname", "data");
            this.getFileData(param, "path2", "fname2", "data2");
            this.getFileData(param, "path3", "fname3", "data3");
        }
        param.remove("srt");
        String sign = SignCommonUtil.signWithParamsOnly(param, secretKey);
        param.put("sign", sign);
        System.out.println("sign:" + sign);
        return HttpsUtils.doPost(url, this.assemeblyPostData(param), this.READ_TIMEOUT, this.CONNECT_TIMEOUT);
    }

    public String postHttps(String url, Map<String, String> param) throws IllegalArgumentException, Exception {
        if (url.endsWith("/login") || !url.contains("/save/")) {
            return this.postHttpsOld(url, param);
        }
        try {
            if (param.containsKey("vno") || param.containsKey("vclN") || param.containsKey("vin") || param.containsKey("vclNs") || param.containsKey("vnos")) {
                String whiteListUrl = url.replaceAll("/save/apis/.*", "/save/apis/whitelist");
                this.postHttpsJWT(whiteListUrl, new HashMap<String, String>(param));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.postHttpsJWT(url, param);
    }

    public String postHttpsJWT(String url, Map<String, String> param) throws IllegalArgumentException, Exception {
        if (null == url || url.length() == 0 || param == null || param.isEmpty()) {
            throw new IllegalArgumentException("url or param is required");
        }
        String secretKey = param.get("srt");
        if (secretKey == null || "null".equals(secretKey.trim()) || "".equals(secretKey.trim())) {
            throw new IllegalArgumentException("srt is required");
        }
        String clientId = param.get("cid");
        if (clientId == null || "null".equals(clientId.trim()) || "".equals(clientId.trim())) {
            throw new IllegalArgumentException("cid is required");
        }
        if (param.containsKey("path")) {
            this.getFileData(param, "path", "fname", "data");
            this.getFileData(param, "path2", "fname2", "data2");
            this.getFileData(param, "path3", "fname3", "data3");
        }
        String head = "{\"alg\": \"HS256\"}";
        String payload = "{\"cid\":\"" + clientId + "\",\"systime\":\"" + System.currentTimeMillis() + "\",\"v\":\"" + "8.0" + "\"}";
        StringBuffer body = new StringBuffer();
        param.remove("srt");
        param.remove("cid");
        ArrayList<String> paramValueList = new ArrayList<String>();
        if (param != null) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                paramValueList.add(entry.getKey() + entry.getValue());
            }
        }
        Collections.sort(paramValueList);
        for (String paramValue : paramValueList) {
            body.append(paramValue);
        }
        String headPayload = Base64.encode(head.getBytes()) + "." + Base64.encode(payload.getBytes());
        String headPayloadBody = headPayload + "." + Base64.encode(body.toString().getBytes());
        String signature = HS256Util.generateSignature(headPayloadBody, secretKey);
        headPayload = headPayload + "." + signature;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("cid", clientId);
        headers.put("sdkV", "8.0");
        return HttpsUtils.doPost(url, headPayload, this.assemeblyPostData(param), headers, this.READ_TIMEOUT, this.CONNECT_TIMEOUT);
    }

    private void getFileData(Map<String, String> param, String fileName, String fname, String fdata) throws Exception {
        try {
            String path = param.get(fileName);
            File file = null;
            if ("path".equals(fileName)) {
                if (path == null || "null".equals(path.trim()) || "".equals(path.trim())) {
                    throw new IllegalArgumentException("path is required");
                }
                file = new File(path);
            } else if (path != null && !"null".equals(path.trim()) && !"".equals(path.trim())) {
                file = new File(path);
            }
            if (file == null) {
                return;
            }
            param.remove(fileName);
            long length = file.length();
            if (length > 0x500000L) {
                throw new IllegalArgumentException("file size is over limit 5M");
            }
            byte[] bFile = Files.readAllBytes(new File(path).toPath());
            String data = Base64.encode(bFile);
            param.put(fname, file.getName());
            param.put(fdata, data);
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + ",e:" + e.toString());
            throw e;
        }
    }

    private String assemeblyPostData(Map<String, String> param) {
        StringBuffer buffer = new StringBuffer(200);
        if (param != null && !param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                buffer.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            buffer.deleteCharAt(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

