/*
 * Decompiled with CFR 0.152.
 */
package com.openapi.sdk.sign;

import com.openapi.sdk.sign.SecurityUtil;
import com.openapi.sdk.sign.SignStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SignCommonUtil {
    public static String signWithParamsAndUrlPath(String urlPath, Map<String, String> params, String secretKey) {
        ArrayList<String> paramValueList = new ArrayList<String>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                paramValueList.add(entry.getKey() + entry.getValue());
            }
        }
        String[] datas = new String[1 + paramValueList.size()];
        datas[0] = urlPath;
        Collections.sort(paramValueList);
        for (int i = 0; i < paramValueList.size(); ++i) {
            datas[i + 1] = (String)paramValueList.get(i);
        }
        byte[] signature = SecurityUtil.hmacSha1(datas, SignStringUtil.toBytes(secretKey));
        return SignStringUtil.encodeHexStr(signature);
    }

    public static String signWithParamsOnly(Map<String, String> params, String secretKey) {
        ArrayList<String> paramValueList = new ArrayList<String>();
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                paramValueList.add(entry.getKey() + entry.getValue());
            }
        }
        Collections.sort(paramValueList);
        String[] datas = new String[paramValueList.size()];
        paramValueList.toArray(datas);
        byte[] signature = SecurityUtil.hmacSha1(datas, SignStringUtil.toBytes(secretKey));
        return SignStringUtil.encodeHexStr(signature);
    }

    public static String getWholeUrl(String url, Map<String, String> params) {
        String param;
        Map.Entry<String, String> entry;
        if (url == null) {
            return null;
        }
        if (params == null) {
            return url;
        }
        Set<Map.Entry<String, String>> set = params.entrySet();
        if (set.size() <= 0) {
            return url;
        }
        url = url + "?";
        Iterator<Map.Entry<String, String>> it = set.iterator();
        if (it.hasNext()) {
            entry = it.next();
            param = entry.getKey() + "=" + entry.getValue();
            url = url + param;
        }
        while (it.hasNext()) {
            entry = it.next();
            param = entry.getKey() + "=" + entry.getValue();
            url = url + "&" + param;
        }
        return url;
    }

    private SignCommonUtil() {
    }
}

