/*
 * Decompiled with CFR 0.152.
 */
package com.openapi.sdk.util;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpsUtils {
    public static String doPost(String url, int connentTimeout, int readTimeout) throws Exception {
        BufferedInputStream bufin = null;
        HttpURLConnection conn = null;
        StringBuffer result = new StringBuffer();
        try {
            HttpsUtils.trustAllHttpsCertificates();
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(connentTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setRequestProperty("Accept-Encoding", "gzip");
            bufin = new BufferedInputStream(conn.getInputStream());
            String contentEncoding = conn.getContentEncoding();
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                bufin = new BufferedInputStream(new GZIPInputStream(bufin));
            }
            byte[] c = new byte[1000];
            int n = 0;
            while ((n = bufin.read(c)) != -1) {
                String temp = new String(c, 0, n, "UTF-8");
                result.append(temp);
            }
            bufin.close();
        }
        catch (Exception e) {
            System.err.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage());
            throw e;
        }
        finally {
            try {
                if (bufin != null) {
                    bufin.close();
                }
            }
            catch (IOException ex) {
                System.err.println("\u5173\u95ed\u6570\u636e\u6d41\u51fa\u9519\u4e86\uff01\n" + ex.getMessage() + "\n");
                throw ex;
            }
        }
        return result.toString();
    }

    public static String doPost(String url, String param, int readTimeout, int connectTimeout) throws Exception {
        BufferedInputStream bufin = null;
        HttpURLConnection conn = null;
        FilterOutputStream dos = null;
        StringBuffer result = new StringBuffer();
        try {
            HttpsUtils.trustAllHttpsCertificates();
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Length", param.getBytes("UTF-8").length + "");
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(connectTimeout);
            conn.setRequestProperty("charset", "UTF-8");
            conn.setReadTimeout(readTimeout);
            conn.setRequestProperty("Accept-Encoding", "gzip");
            conn.connect();
            dos = new DataOutputStream(conn.getOutputStream());
            int length = 0;
            int totalLength = param.length();
            while (length < totalLength) {
                int endLength = length + 1024;
                if (endLength > totalLength) {
                    endLength = totalLength;
                }
                dos.write(param.substring(length, endLength).getBytes("UTF-8"));
                length = endLength;
                ((DataOutputStream)dos).flush();
            }
            dos.close();
            bufin = new BufferedInputStream(conn.getInputStream());
            String contentEncoding = conn.getContentEncoding();
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                bufin = new BufferedInputStream(new GZIPInputStream(bufin));
            }
            byte[] c = new byte[2048];
            int n = 0;
            while ((n = bufin.read(c)) != -1) {
                String temp = new String(c, 0, n, "UTF-8");
                result.append(temp);
            }
            bufin.close();
        }
        catch (Exception e) {
            System.err.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage() + "e:" + e);
            throw e;
        }
        finally {
            try {
                if (bufin != null) {
                    bufin.close();
                }
                if (dos != null) {
                    dos.close();
                }
            }
            catch (IOException ex) {
                System.err.println("\u5173\u95ed\u6570\u636e\u6d41\u51fa\u9519\u4e86\uff01\n" + ex.getMessage() + "\n");
                throw ex;
            }
        }
        return result.toString();
    }

    public static String doPost(String url, String token, String param, Map<String, String> headers, int readTimeout, int connectTimeout) throws Exception {
        BufferedInputStream bufin = null;
        HttpURLConnection conn = null;
        FilterOutputStream dos = null;
        StringBuffer result = new StringBuffer();
        try {
            HttpsUtils.trustAllHttpsCertificates();
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    System.out.println("Warning: URL Host: " + urlHostName + " vs. " + session.getPeerHost());
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestProperty("Content-Length", param.getBytes("UTF-8").length + "");
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(connectTimeout);
            conn.setRequestProperty("charset", "UTF-8");
            conn.setReadTimeout(readTimeout);
            conn.setRequestProperty("Accept-Encoding", "gzip");
            conn.setRequestProperty("Authorization", "Bearer " + token);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            conn.connect();
            dos = new DataOutputStream(conn.getOutputStream());
            int length = 0;
            int totalLength = param.length();
            while (length < totalLength) {
                int endLength = length + 1024;
                if (endLength > totalLength) {
                    endLength = totalLength;
                }
                dos.write(param.substring(length, endLength).getBytes("UTF-8"));
                length = endLength;
                ((DataOutputStream)dos).flush();
            }
            dos.close();
            bufin = new BufferedInputStream(conn.getInputStream());
            String contentEncoding = conn.getContentEncoding();
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase("gzip")) {
                bufin = new BufferedInputStream(new GZIPInputStream(bufin));
            }
            byte[] c = new byte[2048];
            int n = 0;
            while ((n = bufin.read(c)) != -1) {
                String temp = new String(c, 0, n, "UTF-8");
                result.append(temp);
            }
            bufin.close();
        }
        catch (Exception e) {
            System.err.println("\u53d1\u9001 POST \u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e.getMessage() + "e:" + e);
            throw e;
        }
        finally {
            try {
                if (bufin != null) {
                    bufin.close();
                }
                if (dos != null) {
                    dos.close();
                }
            }
            catch (IOException ex) {
                System.err.println("\u5173\u95ed\u6570\u636e\u6d41\u51fa\u9519\u4e86\uff01\n" + ex.getMessage() + "\n");
                throw ex;
            }
        }
        return result.toString();
    }

    private static void trustAllHttpsCertificates() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    static class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

