/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.discovery;

import de.codecentric.boot.admin.discovery.DefaultServiceInstanceConverter;
import de.codecentric.boot.admin.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.context.event.EventListener;

public class ApplicationDiscoveryListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDiscoveryListener.class);
    private final DiscoveryClient discoveryClient;
    private final ApplicationRegistry registry;
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private ServiceInstanceConverter converter = new DefaultServiceInstanceConverter();
    private Set<String> ignoredServices = new HashSet<String>();

    public ApplicationDiscoveryListener(DiscoveryClient discoveryClient, ApplicationRegistry registry) {
        this.discoveryClient = discoveryClient;
        this.registry = registry;
    }

    @EventListener
    public void onInstanceRegistered(InstanceRegisteredEvent<?> event) {
        this.discover();
    }

    @EventListener
    public void onParentHeartbeat(ParentHeartbeatEvent event) {
        this.discoverIfNeeded(event.getValue());
    }

    @EventListener
    public void onApplicationEvent(HeartbeatEvent event) {
        this.discoverIfNeeded(event.getValue());
    }

    private void discoverIfNeeded(Object value) {
        if (this.monitor.update(value)) {
            this.discover();
        }
    }

    protected void discover() {
        Set<String> staleApplicationIds = this.getAllApplicationIdsFromRegistry();
        for (String serviceId : this.discoveryClient.getServices()) {
            if (this.ignoredServices.contains(serviceId)) continue;
            for (ServiceInstance instance : this.discoveryClient.getInstances(serviceId)) {
                String applicationId = this.register(instance);
                staleApplicationIds.remove(applicationId);
            }
        }
        for (String staleApplicationId : staleApplicationIds) {
            LOGGER.info("Application ({}) missing in DiscoveryClient services ", (Object)staleApplicationId);
            this.registry.deregister(staleApplicationId);
        }
    }

    protected final Set<String> getAllApplicationIdsFromRegistry() {
        HashSet<String> result = new HashSet<String>();
        for (Application application : this.registry.getApplications()) {
            if (this.ignoredServices.contains(application.getName())) continue;
            result.add(application.getId());
        }
        return result;
    }

    protected String register(ServiceInstance instance) {
        try {
            Application application = this.converter.convert(instance);
            if (application != null) {
                return this.registry.register(application).getId();
            }
            LOGGER.warn("No application for service {} registered", (Object)instance);
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't register application for service {}", (Object)instance, (Object)ex);
        }
        return null;
    }

    public void setConverter(ServiceInstanceConverter converter) {
        this.converter = converter;
    }

    public void setIgnoredServices(Set<String> ignoredServices) {
        this.ignoredServices = ignoredServices;
    }
}

