/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import de.codecentric.boot.admin.config.AdminServerWebConfiguration;
import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.RoutesOutdatedEvent;
import de.codecentric.boot.admin.journal.store.HazelcastJournaledEventStore;
import de.codecentric.boot.admin.journal.store.JournaledEventStore;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import de.codecentric.boot.admin.registry.store.HazelcastApplicationStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastAutoConfiguration;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnSingleCandidate(value=HazelcastInstance.class)
@ConditionalOnProperty(prefix="spring.boot.admin.hazelcast", name={"enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={AdminServerWebConfiguration.class})
@AutoConfigureAfter(value={HazelcastAutoConfiguration.class})
public class HazelcastStoreConfiguration {
    @Value(value="${spring.boot.admin.hazelcast.application-store:spring-boot-admin-application-store}")
    private String hazelcastMapName;
    @Value(value="${spring.boot.admin.hazelcast.event-store:spring-boot-admin-event-store}")
    private String eventListName;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private HazelcastInstance hazelcastInstance;

    @Bean
    @ConditionalOnMissingBean
    public ApplicationStore applicationStore() {
        IMap map = this.hazelcastInstance.getMap(this.hazelcastMapName);
        map.addIndex("name", false);
        map.addEntryListener(this.entryListener(), false);
        return new HazelcastApplicationStore((IMap<String, Application>)map);
    }

    @Bean
    @ConditionalOnMissingBean
    public JournaledEventStore journaledEventStore() {
        IList list = this.hazelcastInstance.getList(this.eventListName);
        return new HazelcastJournaledEventStore((IList<ClientApplicationEvent>)list);
    }

    @Bean
    public EntryListener<String, Application> entryListener() {
        return new EntryAdapter<String, Application>(){

            public void onEntryEvent(EntryEvent<String, Application> event) {
                HazelcastStoreConfiguration.this.publisher.publishEvent((Object)new RoutesOutdatedEvent());
            }

            public void onMapEvent(MapEvent event) {
                HazelcastStoreConfiguration.this.publisher.publishEvent((Object)new RoutesOutdatedEvent());
            }
        };
    }
}

