/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.ide;

import dev.equo.ide.IdeHookInstantiated;
import dev.equo.ide.IdeHookM2E;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.wizards.ImportMavenProjectsJob;
import org.eclipse.ui.internal.Workbench;
import org.osgi.framework.BundleContext;

class M2EImpl
implements IdeHookInstantiated {
    IdeHookM2E data;
    boolean isClean;
    BundleContext context;

    M2EImpl(IdeHookM2E data) {
        this.data = data;
    }

    @Override
    public void isClean(boolean isClean) {
        this.isClean = isClean;
    }

    @Override
    public void afterOsgi(BundleContext context) {
        this.context = context;
    }

    @Override
    public void postStartup() throws Exception {
        if (!this.isClean) {
            return;
        }
        Workbench.getInstance().getActiveWorkbenchWindow().run(true, true, this::doImport);
    }

    private LocalProjectScanner instantiateScanner() {
        boolean basedirRemameRequired = false;
        List<String> list = List.of(this.data.rootDir.getAbsolutePath());
        try {
            Constructor c = LocalProjectScanner.class.getConstructor(List.class, Boolean.TYPE, MavenModelManager.class);
            return (LocalProjectScanner)c.newInstance(list, basedirRemameRequired, MavenPlugin.getMavenModelManager());
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor c = LocalProjectScanner.class.getConstructor(File.class, List.class, Boolean.TYPE, MavenModelManager.class);
                return (LocalProjectScanner)c.newInstance(this.data.rootDir, list, basedirRemameRequired, MavenPlugin.getMavenModelManager());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private void doImport(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        IProgressMonitor discoverMonitor = monitor.slice(20);
        IProgressMonitor importMonitor = monitor.slice(80);
        LocalProjectScanner scanner = this.instantiateScanner();
        scanner.run(discoverMonitor);
        ProjectImportConfiguration importConfiguration = new ProjectImportConfiguration();
        List workingSets = List.of();
        HashSet<MavenProjectInfo> projects = new HashSet<MavenProjectInfo>();
        for (MavenProjectInfo p : scanner.getProjects()) {
            this.addAll(p, projects);
        }
        ImportMavenProjectsJob job = new ImportMavenProjectsJob(projects, workingSets, importConfiguration);
        IStatus status = job.runInWorkspace(importMonitor);
        if (!status.isOK()) {
            throw new InvocationTargetException((Throwable)new CoreException(status));
        }
        monitor.done();
    }

    private void addAll(MavenProjectInfo proj, Collection<MavenProjectInfo> projects) {
        projects.add(proj);
        for (MavenProjectInfo child : proj.getProjects()) {
            this.addAll(child, projects);
        }
    }
}

