/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.anthropic.internal.client;

import dev.langchain4j.Internal;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.anthropic.AnthropicTokenUsage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicContentBlockType;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageRequest;
import dev.langchain4j.model.anthropic.internal.api.AnthropicCreateMessageResponse;
import dev.langchain4j.model.anthropic.internal.api.AnthropicDelta;
import dev.langchain4j.model.anthropic.internal.api.AnthropicResponseMessage;
import dev.langchain4j.model.anthropic.internal.api.AnthropicStreamingData;
import dev.langchain4j.model.anthropic.internal.api.AnthropicUsage;
import dev.langchain4j.model.anthropic.internal.client.AnthropicClient;
import dev.langchain4j.model.anthropic.internal.client.AnthropicToolExecutionRequestBuilder;
import dev.langchain4j.model.anthropic.internal.client.Json;
import dev.langchain4j.model.anthropic.internal.mapper.AnthropicMapper;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

@Internal
public class DefaultAnthropicClient
extends AnthropicClient {
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String apiKey;
    private final String version;
    private final String beta;

    public static Builder builder() {
        return new Builder();
    }

    DefaultAnthropicClient(Builder builder) {
        HttpClientBuilder httpClientBuilder = (HttpClientBuilder)Utils.getOrDefault((Object)builder.httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = httpClientBuilder.connectTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.timeout, (Object)httpClientBuilder.connectTimeout())), (Object)Duration.ofSeconds(15L))).readTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.timeout, (Object)httpClientBuilder.readTimeout())), (Object)Duration.ofSeconds(60L))).build();
        this.httpClient = builder.logRequests != null && builder.logRequests != false || builder.logResponses != null && builder.logResponses != false ? new LoggingHttpClient(httpClient, builder.logRequests, builder.logResponses) : httpClient;
        this.baseUrl = ValidationUtils.ensureNotBlank((String)builder.baseUrl, (String)"baseUrl");
        this.apiKey = ValidationUtils.ensureNotBlank((String)builder.apiKey, (String)"apiKey");
        this.version = ValidationUtils.ensureNotBlank((String)builder.version, (String)"version");
        this.beta = builder.beta;
    }

    @Override
    public AnthropicCreateMessageResponse createMessage(AnthropicCreateMessageRequest request) {
        HttpRequest httpRequest = this.toHttpRequest(request);
        SuccessfulHttpResponse successfulHttpResponse = this.httpClient.execute(httpRequest);
        return Json.fromJson(successfulHttpResponse.body(), AnthropicCreateMessageResponse.class);
    }

    @Override
    public void createMessage(AnthropicCreateMessageRequest request, final StreamingChatResponseHandler handler) {
        ServerSentEventListener eventListener = new ServerSentEventListener(){
            final ReentrantLock lock = new ReentrantLock();
            final List<String> contents = Collections.synchronizedList(new ArrayList());
            volatile StringBuffer currentContentBuilder = new StringBuffer();
            final AtomicReference<AnthropicContentBlockType> currentContentBlockStartType = new AtomicReference();
            final Map<Integer, AnthropicToolExecutionRequestBuilder> toolExecutionRequestBuilderMap = new ConcurrentHashMap<Integer, AnthropicToolExecutionRequestBuilder>();
            final AtomicInteger inputTokenCount = new AtomicInteger();
            final AtomicInteger outputTokenCount = new AtomicInteger();
            final AtomicInteger cacheCreationInputTokens = new AtomicInteger();
            final AtomicInteger cacheReadInputTokens = new AtomicInteger();
            final AtomicReference<String> responseId = new AtomicReference();
            final AtomicReference<String> responseModel = new AtomicReference();
            volatile String stopReason;

            private StringBuffer currentContentBuilder() {
                this.lock.lock();
                try {
                    StringBuffer stringBuffer = this.currentContentBuilder;
                    return stringBuffer;
                }
                finally {
                    this.lock.unlock();
                }
            }

            private void setCurrentContentBuilder(StringBuffer stringBuffer) {
                this.lock.lock();
                try {
                    this.currentContentBuilder = stringBuffer;
                }
                finally {
                    this.lock.unlock();
                }
            }

            public void onEvent(ServerSentEvent event) {
                AnthropicStreamingData data = Json.fromJson(event.data(), AnthropicStreamingData.class);
                if ("message_start".equals(event.event())) {
                    this.handleMessageStart(data);
                } else if ("content_block_start".equals(event.event())) {
                    this.handleContentBlockStart(data);
                } else if ("content_block_delta".equals(event.event())) {
                    this.handleContentBlockDelta(data);
                } else if ("content_block_stop".equals(event.event())) {
                    this.handleContentBlockStop();
                } else if ("message_delta".equals(event.event())) {
                    this.handleMessageDelta(data);
                } else if ("message_stop".equals(event.event())) {
                    this.handleMessageStop();
                } else if ("error".equals(event.event())) {
                    this.handleError(event.data());
                }
            }

            private void handleMessageStart(AnthropicStreamingData data) {
                AnthropicResponseMessage message = data.message;
                if (message != null) {
                    if (message.usage != null) {
                        this.handleUsage(message.usage);
                    }
                    if (message.id != null) {
                        this.responseId.set(message.id);
                    }
                    if (message.model != null) {
                        this.responseModel.set(message.model);
                    }
                }
            }

            private void handleUsage(AnthropicUsage usage) {
                if (usage.inputTokens != null) {
                    this.inputTokenCount.set(usage.inputTokens);
                }
                if (usage.outputTokens != null) {
                    this.outputTokenCount.set(usage.outputTokens);
                }
                if (usage.cacheCreationInputTokens != null) {
                    this.cacheCreationInputTokens.set(usage.cacheCreationInputTokens);
                }
                if (usage.cacheReadInputTokens != null) {
                    this.cacheReadInputTokens.set(usage.cacheReadInputTokens);
                }
            }

            private void handleContentBlockStart(AnthropicStreamingData data) {
                if (data.contentBlock == null) {
                    return;
                }
                this.currentContentBlockStartType.set(data.contentBlock.type);
                if (this.currentContentBlockStartType.get() == AnthropicContentBlockType.TEXT) {
                    String text = data.contentBlock.text;
                    if (Utils.isNotNullOrEmpty((String)text)) {
                        this.currentContentBuilder().append(text);
                        try {
                            handler.onPartialResponse(text);
                        }
                        catch (Exception e) {
                            InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)e));
                        }
                    }
                } else if (this.currentContentBlockStartType.get() == AnthropicContentBlockType.TOOL_USE) {
                    this.toolExecutionRequestBuilderMap.putIfAbsent(data.index, new AnthropicToolExecutionRequestBuilder(data.contentBlock.id, data.contentBlock.name));
                }
            }

            private void handleContentBlockDelta(AnthropicStreamingData data) {
                Integer toolExecutionsIndex;
                String partialJson;
                if (data.delta == null) {
                    return;
                }
                if (this.currentContentBlockStartType.get() == AnthropicContentBlockType.TEXT) {
                    String text = data.delta.text;
                    if (Utils.isNotNullOrEmpty((String)text)) {
                        this.currentContentBuilder().append(text);
                        try {
                            handler.onPartialResponse(text);
                        }
                        catch (Exception e) {
                            InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)e));
                        }
                    }
                } else if (this.currentContentBlockStartType.get() == AnthropicContentBlockType.TOOL_USE && Utils.isNotNullOrEmpty((String)(partialJson = data.delta.partialJson)) && (toolExecutionsIndex = data.index) != null) {
                    AnthropicToolExecutionRequestBuilder toolExecutionRequestBuilder = this.toolExecutionRequestBuilderMap.get(toolExecutionsIndex);
                    toolExecutionRequestBuilder.appendArguments(partialJson);
                }
            }

            private void handleContentBlockStop() {
                this.contents.add(this.currentContentBuilder().toString());
                this.setCurrentContentBuilder(new StringBuffer());
            }

            private void handleMessageDelta(AnthropicStreamingData data) {
                if (data.delta != null) {
                    AnthropicDelta delta = data.delta;
                    if (delta.stopReason != null) {
                        this.stopReason = delta.stopReason;
                    }
                }
                if (data.usage != null) {
                    this.handleUsage(data.usage);
                }
            }

            private void handleMessageStop() {
                ChatResponse response = this.build();
                try {
                    handler.onCompleteResponse(response);
                }
                catch (Exception e) {
                    InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)e));
                }
            }

            private ChatResponse build() {
                String text = this.contents.stream().filter(content -> !content.isEmpty()).collect(Collectors.joining("\n"));
                AnthropicTokenUsage tokenUsage = AnthropicTokenUsage.builder().inputTokenCount(this.inputTokenCount.get()).outputTokenCount(this.outputTokenCount.get()).cacheCreationInputTokens(this.cacheCreationInputTokens.get()).cacheReadInputTokens(this.cacheReadInputTokens.get()).build();
                FinishReason finishReason = AnthropicMapper.toFinishReason(this.stopReason);
                ChatResponseMetadata metadata = this.createMetadata(tokenUsage, finishReason);
                if (this.toolExecutionRequestBuilderMap.isEmpty()) {
                    return ChatResponse.builder().aiMessage(AiMessage.from((String)text)).metadata(metadata).build();
                }
                List toolExecutionRequests = this.toolExecutionRequestBuilderMap.values().stream().map(AnthropicToolExecutionRequestBuilder::build).collect(Collectors.toList());
                AiMessage aiMessage = Utils.isNullOrBlank((String)text) ? AiMessage.from(toolExecutionRequests) : AiMessage.from((String)text, toolExecutionRequests);
                return ChatResponse.builder().aiMessage(aiMessage).metadata(metadata).build();
            }

            private ChatResponseMetadata createMetadata(AnthropicTokenUsage tokenUsage, FinishReason finishReason) {
                ChatResponseMetadata.Builder metadataBuilder = ChatResponseMetadata.builder();
                if (this.responseId.get() != null) {
                    metadataBuilder.id(this.responseId.get());
                }
                if (this.responseModel.get() != null) {
                    metadataBuilder.modelName(this.responseModel.get());
                }
                if (tokenUsage != null) {
                    metadataBuilder.tokenUsage((TokenUsage)tokenUsage);
                }
                if (finishReason != null) {
                    metadataBuilder.finishReason(finishReason);
                }
                return metadataBuilder.build();
            }

            private void handleError(String dataString) {
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)new RuntimeException(dataString)));
            }

            public void onError(Throwable error) {
                RuntimeException mappedError = ExceptionMapper.DEFAULT.mapException(error);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedError));
            }
        };
        HttpRequest httpRequest = this.toHttpRequest(request);
        this.httpClient.execute(httpRequest, eventListener);
    }

    private HttpRequest toHttpRequest(AnthropicCreateMessageRequest request) {
        HttpRequest.Builder builder = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "messages").addHeader("Content-Type", new String[]{"application/json"}).addHeader("x-api-key", new String[]{this.apiKey}).addHeader("anthropic-version", new String[]{this.version}).body(Json.toJson(request));
        if (this.beta != null) {
            builder.addHeader("anthropic-beta", new String[]{this.beta});
        }
        return builder.build();
    }

    public static class Builder
    extends AnthropicClient.Builder<DefaultAnthropicClient, Builder> {
        @Override
        public DefaultAnthropicClient build() {
            return new DefaultAnthropicClient(this);
        }
    }
}

