/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock.internal;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.model.bedrock.internal.BedrockEmbeddingResponse;
import dev.langchain4j.model.bedrock.internal.Json;
import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelResponse;

public abstract class AbstractBedrockEmbeddingModel<T extends BedrockEmbeddingResponse>
implements EmbeddingModel {
    private final Region region;
    private final AwsCredentialsProvider credentialsProvider;
    private final AtomicReference<Object> client = new AtomicReference();
    private final Integer maxRetries;

    public Response<List<Embedding>> embedAll(List<TextSegment> textSegments) {
        List<Map<String, Object>> requestParameters = this.getRequestParameters(textSegments);
        List responses = requestParameters.stream().map(Json::toJson).map(body -> (InvokeModelResponse)RetryUtils.withRetry(() -> this.invoke((String)body), (int)this.maxRetries)).map(invokeModelResponse -> invokeModelResponse.body().asUtf8String()).map(response -> (BedrockEmbeddingResponse)Json.fromJson(response, this.getResponseClassType())).collect(Collectors.toList());
        int totalInputToken = 0;
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        for (BedrockEmbeddingResponse response2 : responses) {
            embeddings.add(response2.toEmbedding());
            totalInputToken += response2.getInputTextTokenCount();
        }
        return Response.from(embeddings, (TokenUsage)new TokenUsage(Integer.valueOf(totalInputToken)));
    }

    protected abstract List<Map<String, Object>> getRequestParameters(List<TextSegment> var1);

    protected abstract String getModelId();

    protected abstract Class<T> getResponseClassType();

    protected InvokeModelResponse invoke(String body) {
        InvokeModelRequest invokeModelRequest = (InvokeModelRequest)InvokeModelRequest.builder().modelId(this.getModelId()).body(SdkBytes.fromString((String)body, (Charset)Charset.defaultCharset())).build();
        return this.getClient().invokeModel(invokeModelRequest);
    }

    protected static Map<String, Object> of(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(key, value);
        return map;
    }

    private BedrockRuntimeClient initClient() {
        return (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(this.region)).credentialsProvider(this.credentialsProvider)).build();
    }

    private static <T extends BedrockEmbeddingResponse> Region $default$region() {
        return Region.US_EAST_1;
    }

    private static <T extends BedrockEmbeddingResponse> AwsCredentialsProvider $default$credentialsProvider() {
        return DefaultCredentialsProvider.builder().build();
    }

    private static <T extends BedrockEmbeddingResponse> Integer $default$maxRetries() {
        return 5;
    }

    protected AbstractBedrockEmbeddingModel(AbstractBedrockEmbeddingModelBuilder<T, ?, ?> b) {
        this.region = ((AbstractBedrockEmbeddingModelBuilder)b).region$set ? ((AbstractBedrockEmbeddingModelBuilder)b).region$value : AbstractBedrockEmbeddingModel.$default$region();
        this.credentialsProvider = ((AbstractBedrockEmbeddingModelBuilder)b).credentialsProvider$set ? ((AbstractBedrockEmbeddingModelBuilder)b).credentialsProvider$value : AbstractBedrockEmbeddingModel.$default$credentialsProvider();
        this.maxRetries = ((AbstractBedrockEmbeddingModelBuilder)b).maxRetries$set ? ((AbstractBedrockEmbeddingModelBuilder)b).maxRetries$value : AbstractBedrockEmbeddingModel.$default$maxRetries();
    }

    public Region getRegion() {
        return this.region;
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BedrockRuntimeClient getClient() {
        Object value = this.client.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.client;
            synchronized (atomicReference) {
                value = this.client.get();
                if (value == null) {
                    BedrockRuntimeClient actualValue = this.initClient();
                    value = actualValue == null ? this.client : actualValue;
                    this.client.set(value);
                }
            }
        }
        return (BedrockRuntimeClient)(value == this.client ? null : value);
    }

    public static abstract class AbstractBedrockEmbeddingModelBuilder<T extends BedrockEmbeddingResponse, C extends AbstractBedrockEmbeddingModel<T>, B extends AbstractBedrockEmbeddingModelBuilder<T, C, B>> {
        private boolean region$set;
        private Region region$value;
        private boolean credentialsProvider$set;
        private AwsCredentialsProvider credentialsProvider$value;
        private boolean maxRetries$set;
        private Integer maxRetries$value;

        public B region(Region region) {
            this.region$value = region;
            this.region$set = true;
            return this.self();
        }

        public B credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.credentialsProvider$value = credentialsProvider;
            this.credentialsProvider$set = true;
            return this.self();
        }

        public B maxRetries(Integer maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "AbstractBedrockEmbeddingModel.AbstractBedrockEmbeddingModelBuilder(region$value=" + this.region$value + ", credentialsProvider$value=" + this.credentialsProvider$value + ", maxRetries$value=" + this.maxRetries$value + ")";
        }
    }
}

