/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan;

import dev.langchain4j.community.model.qianfan.InternalQianfanHelper;
import dev.langchain4j.community.model.qianfan.QianfanChatModelNameEnum;
import dev.langchain4j.community.model.qianfan.QianfanStreamingResponseBuilder;
import dev.langchain4j.community.model.qianfan.client.QianfanClient;
import dev.langchain4j.community.model.qianfan.client.SyncOrAsyncOrStreaming;
import dev.langchain4j.community.model.qianfan.client.chat.ChatCompletionRequest;
import dev.langchain4j.community.model.qianfan.client.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.qianfan.spi.QianfanStreamingChatModelBuilderFactory;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class QianfanStreamingChatModel
implements StreamingChatModel {
    private final QianfanClient client;
    private final List<ChatModelListener> listeners;
    private final ChatRequestParameters defaultRequestParameters;
    private final String endpoint;
    private final String userId;

    public QianfanStreamingChatModel(String baseUrl, String apiKey, String secretKey, Double temperature, Double topP, String modelName, String endpoint, String responseFormat, Double penaltyScore, Boolean logRequests, Boolean logResponses, String userId, List<String> stop, Integer maxOutputTokens, Proxy proxy, List<ChatModelListener> listeners) {
        if (Utils.isNullOrBlank((String)apiKey) || Utils.isNullOrBlank((String)secretKey)) {
            throw new IllegalArgumentException(" api key and secret key must be defined. It can be generated here: https://console.bce.baidu.com/qianfan/ais/console/applicationConsole/application");
        }
        String string = this.endpoint = Utils.isNullOrBlank((String)endpoint) ? QianfanChatModelNameEnum.fromModelName(modelName) : endpoint;
        if (Utils.isNullOrBlank((String)this.endpoint)) {
            throw new IllegalArgumentException("Qianfan does not have such model name. You can see model name here: https://cloud.baidu.com/doc/WENXINWORKSHOP/s/Nlks5zkzu");
        }
        this.listeners = Utils.copy(listeners);
        this.client = QianfanClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://aip.baidubce.com")).apiKey(apiKey).secretKey(secretKey).logRequests(logRequests).logResponses(logResponses).proxy(proxy).build();
        this.defaultRequestParameters = ChatRequestParameters.builder().temperature(temperature).topP(topP).stopSequences(stop).modelName((String)ValidationUtils.ensureNotNull((Object)modelName, (String)"modelName")).maxOutputTokens(maxOutputTokens).responseFormat("json_object".equals(responseFormat) ? ResponseFormat.JSON : ResponseFormat.TEXT).presencePenalty(penaltyScore).build();
        this.userId = userId;
    }

    public ChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        List messages = chatRequest.messages();
        List toolSpecifications = chatRequest.toolSpecifications();
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatCompletionRequest.Builder builder = ChatCompletionRequest.builder().messages(InternalQianfanHelper.toOpenAiMessages(messages)).temperature(parameters.temperature()).topP(parameters.topP()).maxOutputTokens(parameters.maxOutputTokens()).stop(parameters.stopSequences()).stream(true).system(InternalQianfanHelper.getSystemMessage(messages)).userId(this.userId).responseFormat(parameters.responseFormat() == ResponseFormat.JSON ? "json_object" : "text").penaltyScore(parameters.presencePenalty());
        if (toolSpecifications != null && !toolSpecifications.isEmpty()) {
            builder.functions(InternalQianfanHelper.toFunctions(toolSpecifications));
        }
        ChatCompletionRequest request = builder.build();
        QianfanStreamingResponseBuilder responseBuilder = new QianfanStreamingResponseBuilder(null);
        SyncOrAsyncOrStreaming<ChatCompletionResponse> response = this.client.chatCompletion(request, this.endpoint);
        response.onPartialResponse(partialResponse -> {
            try {
                responseBuilder.append((ChatCompletionResponse)partialResponse);
                QianfanStreamingChatModel.handle(partialResponse, handler);
            }
            catch (Throwable t) {
                RuntimeException mappedException = ExceptionMapper.DEFAULT.mapException(t);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedException));
            }
        }).onComplete(() -> {
            try {
                ChatResponse chatResponse = responseBuilder.build();
                handler.onCompleteResponse(chatResponse);
            }
            catch (Throwable t) {
                RuntimeException mappedException = ExceptionMapper.DEFAULT.mapException(t);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedException));
            }
        }).onError(throwable -> {
            RuntimeException mappedException = ExceptionMapper.DEFAULT.mapException(throwable);
            InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedException));
        }).execute();
    }

    private static void handle(ChatCompletionResponse partialResponse, StreamingChatResponseHandler handler) {
        String result = partialResponse.getResult();
        if (Objects.isNull(result) || result.isEmpty()) {
            return;
        }
        handler.onPartialResponse(result);
    }

    public static QianfanStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QianfanStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QianfanStreamingChatModelBuilderFactory factory = (QianfanStreamingChatModelBuilderFactory)iterator.next();
            return (QianfanStreamingChatModelBuilder)factory.get();
        }
        return new QianfanStreamingChatModelBuilder();
    }

    public static class QianfanStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String secretKey;
        private Double temperature;
        private Double topP;
        private String modelName;
        private String endpoint;
        private String responseFormat;
        private Double penaltyScore;
        private Boolean logRequests;
        private Boolean logResponses;
        private String userId;
        private List<String> stop;
        private Integer maxOutputTokens;
        private Proxy proxy;
        private List<ChatModelListener> listeners;

        public QianfanStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QianfanStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QianfanStreamingChatModelBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public QianfanStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public QianfanStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QianfanStreamingChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QianfanStreamingChatModelBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public QianfanStreamingChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public QianfanStreamingChatModelBuilder penaltyScore(Double penaltyScore) {
            this.penaltyScore = penaltyScore;
            return this;
        }

        public QianfanStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public QianfanStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public QianfanStreamingChatModelBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QianfanStreamingChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public QianfanStreamingChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public QianfanStreamingChatModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public QianfanStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public QianfanStreamingChatModel build() {
            return new QianfanStreamingChatModel(this.baseUrl, this.apiKey, this.secretKey, this.temperature, this.topP, this.modelName, this.endpoint, this.responseFormat, this.penaltyScore, this.logRequests, this.logResponses, this.userId, this.stop, this.maxOutputTokens, this.proxy, this.listeners);
        }
    }
}

