/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan.client.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.community.model.qianfan.client.chat.Examples;
import dev.langchain4j.community.model.qianfan.client.chat.Parameters;
import dev.langchain4j.community.model.qianfan.client.chat.Responses;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Function {
    private final String name;
    private final String description;
    private final Parameters parameters;
    private final Responses responses;
    private final Examples examples;

    private Function(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.examples = builder.examples;
        this.responses = builder.responses;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Responses getResponses() {
        return this.responses;
    }

    public Examples getExamples() {
        return this.examples;
    }

    public String toString() {
        return "Function{name='" + this.name + "', description='" + this.description + "', parameters=" + String.valueOf(this.parameters) + ", responses=" + String.valueOf(this.responses) + ", examples=" + String.valueOf(this.examples) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private String description;
        private Parameters parameters;
        private Responses responses;
        private Examples examples;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder responses(Responses responses) {
            this.responses = responses;
            return this;
        }

        public Builder examples(Examples examples) {
            this.examples = examples;
            return this;
        }

        public Function build() {
            return new Function(this);
        }
    }
}

