/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference;

import dev.langchain4j.community.model.xinference.client.chat.message.ImageUrl;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.internal.Utils;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;

class ImageUtils {
    private static final List<String> SUPPORTED_URL_SCHEMES = Arrays.asList("http", "https", "file");

    ImageUtils() {
    }

    static byte[] imageByteArray(Image image) {
        if (image.base64Data() != null && !image.base64Data().isBlank()) {
            return Base64.getDecoder().decode(image.base64Data());
        }
        if (SUPPORTED_URL_SCHEMES.contains(image.url().getScheme())) {
            return Utils.readBytes((String)image.url().toString());
        }
        throw new RuntimeException("only supports http/https and file urls. unsupported url scheme: " + image.url().getScheme());
    }

    static ImageUrl base64Image(Image image, String detailLevel) {
        String url = "";
        url = Objects.nonNull(image.url()) ? image.url().toString() : String.format("data:%s;base64,%s", image.mimeType(), image.base64Data());
        return ImageUrl.of(url, ImageUrl.ImageDetail.valueOf(detailLevel));
    }
}

