/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.xinference.ImageUtils;
import dev.langchain4j.community.model.xinference.client.chat.Function;
import dev.langchain4j.community.model.xinference.client.chat.Parameters;
import dev.langchain4j.community.model.xinference.client.chat.Tool;
import dev.langchain4j.community.model.xinference.client.chat.ToolType;
import dev.langchain4j.community.model.xinference.client.chat.message.AssistantMessage;
import dev.langchain4j.community.model.xinference.client.chat.message.Content;
import dev.langchain4j.community.model.xinference.client.chat.message.FunctionCall;
import dev.langchain4j.community.model.xinference.client.chat.message.Message;
import dev.langchain4j.community.model.xinference.client.chat.message.SystemMessage;
import dev.langchain4j.community.model.xinference.client.chat.message.ToolCall;
import dev.langchain4j.community.model.xinference.client.chat.message.ToolMessage;
import dev.langchain4j.community.model.xinference.client.chat.message.UserMessage;
import dev.langchain4j.community.model.xinference.client.chat.message.VideoUrl;
import dev.langchain4j.community.model.xinference.client.shared.CompletionUsage;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.VideoContent;
import dev.langchain4j.data.video.Video;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

class InternalXinferenceHelper {
    InternalXinferenceHelper() {
    }

    static List<Message> toXinferenceMessages(List<ChatMessage> messages) {
        if (Utils.isNullOrEmpty(messages)) {
            return null;
        }
        return messages.stream().map(msg -> {
            if (msg instanceof dev.langchain4j.data.message.SystemMessage) {
                dev.langchain4j.data.message.SystemMessage message = (dev.langchain4j.data.message.SystemMessage)msg;
                return SystemMessage.of(message.text());
            }
            if (msg instanceof AiMessage) {
                AiMessage message = (AiMessage)msg;
                if (!message.hasToolExecutionRequests()) {
                    return AssistantMessage.of(message.text(), new ToolCall[0]);
                }
                List<ToolCall> list = message.toolExecutionRequests().stream().map(it -> ToolCall.builder().id(it.id()).type(ToolType.FUNCTION).function(FunctionCall.builder().id(it.id()).name(it.name()).arguments(it.arguments()).build()).build()).toList();
                return AssistantMessage.of(message.text(), list.toArray(new ToolCall[0]));
            }
            if (msg instanceof dev.langchain4j.data.message.UserMessage) {
                dev.langchain4j.data.message.UserMessage message = (dev.langchain4j.data.message.UserMessage)msg;
                if (message.hasSingleText()) {
                    return UserMessage.builder().content(message.singleText()).name(message.name()).build();
                }
                List<Content> list = message.contents().stream().map(item -> {
                    if (item instanceof TextContent) {
                        TextContent content = (TextContent)item;
                        return Content.text(content.text());
                    }
                    if (item instanceof ImageContent) {
                        ImageContent content = (ImageContent)item;
                        return Content.image(ImageUtils.base64Image(content.image(), content.detailLevel().name()));
                    }
                    if (item instanceof VideoContent) {
                        VideoContent content = (VideoContent)item;
                        String url = null;
                        Video video = content.video();
                        if (Objects.nonNull(video.url())) {
                            url = video.url().toString();
                        } else if (Utils.isNotNullOrBlank((String)video.base64Data())) {
                            url = InternalXinferenceHelper.saveDataAsTemporaryFile(video.base64Data(), video.mimeType());
                        }
                        return Content.video(VideoUrl.of(url));
                    }
                    throw Exceptions.illegalArgument((String)("Unknown content type: " + String.valueOf(item)), (Object[])new Object[0]);
                }).toList();
                return UserMessage.builder().content(list).name(message.name()).build();
            }
            if (msg instanceof ToolExecutionResultMessage) {
                ToolExecutionResultMessage message = (ToolExecutionResultMessage)msg;
                return ToolMessage.of(message.id(), message.text());
            }
            throw Exceptions.illegalArgument((String)("Unknown message type: " + String.valueOf(msg.type())), (Object[])new Object[0]);
        }).toList();
    }

    static List<Tool> toTools(List<ToolSpecification> toolSpecifications) {
        if (Utils.isNullOrEmpty(toolSpecifications)) {
            return null;
        }
        return toolSpecifications.stream().map(InternalXinferenceHelper::toTool).toList();
    }

    static Tool toTool(ToolSpecification toolSpecification) {
        return Tool.builder().function(Function.builder().description(toolSpecification.description()).name(toolSpecification.name()).parameters(InternalXinferenceHelper.toParameters(toolSpecification)).build()).build();
    }

    static Tool toToolChoice(ToolSpecification toolSpecification) {
        return Tool.builder().function(Function.builder().name(toolSpecification.name()).build()).build();
    }

    static AiMessage aiMessageFrom(AssistantMessage assistantMessage) {
        String text = assistantMessage.getContent();
        List<ToolCall> toolCalls = assistantMessage.getToolCalls();
        if (!Utils.isNullOrEmpty(toolCalls)) {
            List<ToolExecutionRequest> toolExecutionRequests = toolCalls.stream().filter(toolCall -> toolCall.getType() == ToolType.FUNCTION).map(InternalXinferenceHelper::toToolExecutionRequest).toList();
            return Utils.isNullOrBlank((String)text) ? AiMessage.from(toolExecutionRequests) : AiMessage.from((String)text, toolExecutionRequests);
        }
        return AiMessage.from((String)text);
    }

    private static ToolExecutionRequest toToolExecutionRequest(ToolCall toolCall) {
        FunctionCall functionCall = toolCall.getFunction();
        return ToolExecutionRequest.builder().id(toolCall.getId()).name(functionCall.getName()).arguments(functionCall.getArguments()).build();
    }

    private static Parameters toParameters(ToolSpecification toolSpecification) {
        if (toolSpecification.parameters() != null) {
            JsonObjectSchema parameters = toolSpecification.parameters();
            return Parameters.builder().properties(JsonSchemaElementUtils.toMap((Map)parameters.properties())).required(parameters.required()).build();
        }
        return null;
    }

    public static TokenUsage tokenUsageFrom(CompletionUsage usage) {
        if (Objects.isNull(usage)) {
            return null;
        }
        return new TokenUsage(usage.getPromptTokens(), usage.getCompletionTokens(), usage.getTotalTokens());
    }

    public static FinishReason finishReasonFrom(String finishReason) {
        if (Utils.isNullOrBlank((String)finishReason)) {
            return null;
        }
        return switch (finishReason) {
            case "stop" -> FinishReason.STOP;
            case "length" -> FinishReason.LENGTH;
            case "tool_calls", "function_call" -> FinishReason.TOOL_EXECUTION;
            case "content_filter" -> FinishReason.CONTENT_FILTER;
            default -> null;
        };
    }

    static String saveDataAsTemporaryFile(String base64Data, String mimeType) {
        int lastSlashIndex;
        String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
        Object tmpFileName = UUID.randomUUID().toString();
        if (Utils.isNotNullOrBlank((String)mimeType) && (lastSlashIndex = mimeType.lastIndexOf("/")) >= 0 && lastSlashIndex < mimeType.length() - 1) {
            String fileSuffix = mimeType.substring(lastSlashIndex + 1);
            tmpFileName = (String)tmpFileName + "." + fileSuffix;
        }
        Path tmpFilePath = Paths.get(tmpDir, new String[]{tmpFileName});
        byte[] data = Base64.getDecoder().decode(base64Data);
        try {
            Files.copy(new ByteArrayInputStream(data), tmpFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tmpFilePath.toAbsolutePath().toUri().toString();
    }
}

