/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference;

import dev.langchain4j.community.model.xinference.ImageUtils;
import dev.langchain4j.community.model.xinference.client.SyncOrAsync;
import dev.langchain4j.community.model.xinference.client.XinferenceClient;
import dev.langchain4j.community.model.xinference.client.image.ImageData;
import dev.langchain4j.community.model.xinference.client.image.ImageRequest;
import dev.langchain4j.community.model.xinference.client.image.ImageResponse;
import dev.langchain4j.community.model.xinference.client.image.ResponseFormat;
import dev.langchain4j.community.model.xinference.spi.XinferenceImageModelBuilderFactory;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XinferenceImageModel
implements ImageModel {
    private final XinferenceClient client;
    private final String modelName;
    private final String negativePrompt;
    private final ResponseFormat responseFormat;
    private final String size;
    private final String kwargs;
    private final String user;
    private final Integer maxRetries;

    public XinferenceImageModel(String baseUrl, String apiKey, String modelName, String negativePrompt, ResponseFormat responseFormat, String size, String kwargs, String user, Integer maxRetries, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses, Map<String, String> customHeaders) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = XinferenceClient.builder().baseUrl(baseUrl).apiKey(apiKey).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).customHeaders(customHeaders).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.negativePrompt = negativePrompt;
        this.responseFormat = (ResponseFormat)((Object)Utils.getOrDefault((Object)((Object)responseFormat), (Object)((Object)ResponseFormat.B64_JSON)));
        this.size = (String)Utils.getOrDefault((Object)size, (Object)"256x256");
        this.kwargs = kwargs;
        this.user = user;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public Response<Image> generate(String prompt) {
        ImageRequest request = ImageRequest.builder().model(this.modelName).prompt(prompt).negativePrompt(this.negativePrompt).responseFormat(this.responseFormat).size(this.size).kwargs(this.kwargs).user(this.user).build();
        ImageResponse response = (ImageResponse)((SyncOrAsync)RetryUtils.withRetry(() -> this.client.generations(request), (int)this.maxRetries)).execute();
        return Response.from((Object)XinferenceImageModel.fromImageData(response.getData().get(0)));
    }

    public Response<List<Image>> generate(String prompt, int total) {
        ImageRequest request = ImageRequest.builder().model(this.modelName).prompt(prompt).negativePrompt(this.negativePrompt).n(total).responseFormat(this.responseFormat).size(this.size).kwargs(this.kwargs).user(this.user).build();
        ImageResponse response = (ImageResponse)((SyncOrAsync)RetryUtils.withRetry(() -> this.client.generations(request), (int)this.maxRetries)).execute();
        List<Image> list = response.getData().stream().map(XinferenceImageModel::fromImageData).toList();
        return Response.from(list);
    }

    public Response<Image> edit(Image image, String prompt) {
        ImageRequest request = ImageRequest.builder().model(this.modelName).prompt(prompt).negativePrompt(this.negativePrompt).responseFormat(this.responseFormat).size(this.size).kwargs(this.kwargs).user(this.user).build();
        ImageResponse response = (ImageResponse)((SyncOrAsync)RetryUtils.withRetry(() -> this.client.variations(request, ImageUtils.imageByteArray(image)), (int)this.maxRetries)).execute();
        return Response.from((Object)XinferenceImageModel.fromImageData(response.getData().get(0)));
    }

    public Response<Image> edit(Image image, Image mask, String prompt) {
        ImageRequest request = ImageRequest.builder().model(this.modelName).prompt(prompt).negativePrompt(this.negativePrompt).responseFormat(this.responseFormat).size(this.size).kwargs(this.kwargs).user(this.user).build();
        ImageResponse response = (ImageResponse)((SyncOrAsync)RetryUtils.withRetry(() -> this.client.inpainting(request, ImageUtils.imageByteArray(image), ImageUtils.imageByteArray(mask)), (int)this.maxRetries)).execute();
        return Response.from((Object)XinferenceImageModel.fromImageData(response.getData().get(0)));
    }

    private static Image fromImageData(ImageData data) {
        Image.Builder builder = Image.builder().base64Data(data.getB64Json());
        if (Utils.isNotNullOrBlank((String)data.getUrl())) {
            builder.url(data.getUrl());
        }
        return builder.build();
    }

    public static XinferenceImageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(XinferenceImageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            XinferenceImageModelBuilderFactory factory = (XinferenceImageModelBuilderFactory)iterator.next();
            return (XinferenceImageModelBuilder)factory.get();
        }
        return new XinferenceImageModelBuilder();
    }

    public static class XinferenceImageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private String negativePrompt;
        private ResponseFormat responseFormat;
        private String size;
        private String kwargs;
        private String user;
        private Integer maxRetries;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Map<String, String> customHeaders;

        public XinferenceImageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public XinferenceImageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public XinferenceImageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public XinferenceImageModelBuilder negativePrompt(String negativePrompt) {
            this.negativePrompt = negativePrompt;
            return this;
        }

        public XinferenceImageModelBuilder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public XinferenceImageModelBuilder size(String size) {
            this.size = size;
            return this;
        }

        public XinferenceImageModelBuilder kwargs(String kwargs) {
            this.kwargs = kwargs;
            return this;
        }

        public XinferenceImageModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public XinferenceImageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public XinferenceImageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public XinferenceImageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public XinferenceImageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public XinferenceImageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public XinferenceImageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public XinferenceImageModel build() {
            return new XinferenceImageModel(this.baseUrl, this.apiKey, this.modelName, this.negativePrompt, this.responseFormat, this.size, this.kwargs, this.user, this.maxRetries, this.timeout, this.proxy, this.logRequests, this.logResponses, this.customHeaders);
        }
    }
}

