/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference;

import dev.langchain4j.community.model.xinference.InternalXinferenceHelper;
import dev.langchain4j.community.model.xinference.client.XinferenceClient;
import dev.langchain4j.community.model.xinference.client.completion.CompletionChoice;
import dev.langchain4j.community.model.xinference.client.completion.CompletionRequest;
import dev.langchain4j.community.model.xinference.client.completion.CompletionResponse;
import dev.langchain4j.community.model.xinference.spi.XinferenceLanguageModelBuilderFactory;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XinferenceLanguageModel
implements LanguageModel {
    private final XinferenceClient client;
    private final String modelName;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Integer logprobs;
    private final Boolean echo;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final String user;
    private final Integer maxRetries;

    public XinferenceLanguageModel(String baseUrl, String apiKey, String modelName, Integer maxTokens, Double temperature, Double topP, Integer logprobs, Boolean echo, List<String> stop, Double presencePenalty, Double frequencyPenalty, String user, Integer maxRetries, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses, Map<String, String> customHeaders) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = XinferenceClient.builder().baseUrl(baseUrl).apiKey(apiKey).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).customHeaders(customHeaders).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.logprobs = logprobs;
        this.echo = echo;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.user = user;
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public Response<String> generate(String prompt) {
        CompletionRequest request = CompletionRequest.builder().model(this.modelName).prompt(prompt).maxTokens(this.maxTokens).temperature(this.temperature).topP(this.topP).logprobs(this.logprobs).echo(this.echo).stop(this.stop).presencePenalty(this.presencePenalty).frequencyPenalty(this.frequencyPenalty).user(this.user).build();
        CompletionResponse response = (CompletionResponse)RetryUtils.withRetry(() -> (CompletionResponse)this.client.completions(request).execute(), (int)this.maxRetries);
        CompletionChoice completionChoice = response.getChoices().get(0);
        return Response.from((Object)completionChoice.getText(), (TokenUsage)InternalXinferenceHelper.tokenUsageFrom(response.getUsage()), (FinishReason)InternalXinferenceHelper.finishReasonFrom(completionChoice.getFinishReason()));
    }

    public static XinferenceLanguageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(XinferenceLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            XinferenceLanguageModelBuilderFactory factory = (XinferenceLanguageModelBuilderFactory)iterator.next();
            return (XinferenceLanguageModelBuilder)factory.get();
        }
        return new XinferenceLanguageModelBuilder();
    }

    public static class XinferenceLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Integer logprobs;
        private Boolean echo;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private String user;
        private Integer maxRetries;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Map<String, String> customHeaders;

        public XinferenceLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public XinferenceLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public XinferenceLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public XinferenceLanguageModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public XinferenceLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public XinferenceLanguageModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public XinferenceLanguageModelBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public XinferenceLanguageModelBuilder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        public XinferenceLanguageModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public XinferenceLanguageModelBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public XinferenceLanguageModelBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public XinferenceLanguageModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public XinferenceLanguageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public XinferenceLanguageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public XinferenceLanguageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public XinferenceLanguageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public XinferenceLanguageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public XinferenceLanguageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public XinferenceLanguageModel build() {
            return new XinferenceLanguageModel(this.baseUrl, this.apiKey, this.modelName, this.maxTokens, this.temperature, this.topP, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty, this.user, this.maxRetries, this.timeout, this.proxy, this.logRequests, this.logResponses, this.customHeaders);
        }
    }
}

