/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference.client.chat.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.community.model.xinference.client.chat.message.ContentType;
import dev.langchain4j.community.model.xinference.client.chat.message.ImageUrl;
import dev.langchain4j.community.model.xinference.client.chat.message.VideoUrl;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class Content {
    private final ContentType type;
    private final String text;
    private final ImageUrl imageUrl;
    private final VideoUrl videoUrl;

    private Content(Builder builder) {
        this.type = builder.type;
        this.text = builder.text;
        this.imageUrl = builder.imageUrl;
        this.videoUrl = builder.videoUrl;
    }

    public ContentType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public ImageUrl getImageUrl() {
        return this.imageUrl;
    }

    public VideoUrl getVideoUrl() {
        return this.videoUrl;
    }

    public static Content text(String text) {
        return Content.builder().type(ContentType.TEXT).text(text).build();
    }

    public static Content image(ImageUrl imageUrl) {
        return Content.builder().type(ContentType.IMAGE_URL).imageUrl(imageUrl).build();
    }

    public static Content video(VideoUrl videoUrl) {
        return Content.builder().type(ContentType.VIDEO_URL).videoUrl(videoUrl).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private ContentType type;
        private String text;
        private ImageUrl imageUrl;
        private VideoUrl videoUrl;

        private Builder() {
        }

        public Builder type(ContentType val) {
            this.type = val;
            return this;
        }

        public Builder text(String val) {
            this.text = val;
            return this;
        }

        public Builder imageUrl(ImageUrl val) {
            this.imageUrl = val;
            return this;
        }

        public Builder videoUrl(VideoUrl val) {
            this.videoUrl = val;
            return this;
        }

        public Content build() {
            return new Content(this);
        }
    }
}

