/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu.embedding;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import dev.langchain4j.community.model.zhipu.embedding.EmbeddingModel;
import dev.langchain4j.internal.Utils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class EmbeddingRequest {
    private String input;
    private String model;
    private Integer dimensions;

    public EmbeddingRequest(String input, String model, Integer dimensions) {
        this.input = input;
        this.model = (String)Utils.getOrDefault((Object)model, (Object)EmbeddingModel.EMBEDDING_2.toString());
        this.dimensions = dimensions;
    }

    public static EmbeddingRequestBuilder builder() {
        return new EmbeddingRequestBuilder();
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Integer getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Integer dimensions) {
        this.dimensions = dimensions;
    }

    public static class EmbeddingRequestBuilder {
        private String input;
        private String model;
        private Integer dimensions;

        EmbeddingRequestBuilder() {
        }

        public EmbeddingRequestBuilder input(String input) {
            this.input = input;
            return this;
        }

        public EmbeddingRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public EmbeddingRequestBuilder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public EmbeddingRequest build() {
            return new EmbeddingRequest(this.input, this.model, this.dimensions);
        }
    }
}

