/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.mcp.client.transport;

import com.fasterxml.jackson.databind.JsonNode;
import dev.langchain4j.mcp.client.McpRoot;
import dev.langchain4j.mcp.client.logging.McpLogMessage;
import dev.langchain4j.mcp.client.protocol.McpPingResponse;
import dev.langchain4j.mcp.client.protocol.McpRootsListResponse;
import dev.langchain4j.mcp.client.transport.McpTransport;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McpOperationHandler {
    private final Map<Long, CompletableFuture<JsonNode>> pendingOperations;
    private static final Logger log = LoggerFactory.getLogger(McpOperationHandler.class);
    private final McpTransport transport;
    private final Consumer<McpLogMessage> logMessageConsumer;
    private final Runnable onToolListUpdate;
    private final Supplier<List<McpRoot>> roots;

    public McpOperationHandler(Map<Long, CompletableFuture<JsonNode>> pendingOperations, Supplier<List<McpRoot>> roots, McpTransport transport, Consumer<McpLogMessage> logMessageConsumer, Runnable onToolListUpdate) {
        this.pendingOperations = pendingOperations;
        this.transport = transport;
        this.logMessageConsumer = logMessageConsumer;
        this.onToolListUpdate = onToolListUpdate;
        this.roots = roots;
    }

    public void handle(JsonNode message) {
        if (message.has("id")) {
            long messageId = message.get("id").asLong();
            if (message.has("result") || message.has("error")) {
                CompletableFuture<JsonNode> op = this.pendingOperations.remove(messageId);
                if (op != null) {
                    op.complete(message);
                } else {
                    log.warn("Received response for unknown message id: {}", (Object)messageId);
                }
            } else {
                if (message.has("method")) {
                    String method = message.get("method").asText();
                    if (method.equals("ping")) {
                        this.transport.executeOperationWithoutResponse(new McpPingResponse(messageId));
                        return;
                    }
                    if (method.equals("roots/list")) {
                        this.transport.executeOperationWithoutResponse(new McpRootsListResponse(messageId, this.roots.get()));
                        return;
                    }
                }
                log.warn("Received response for unknown message id: {}", (Object)messageId);
            }
        } else if (message.has("method")) {
            String method = message.get("method").asText();
            if (method.equals("notifications/message")) {
                if (message.has("params")) {
                    if (this.logMessageConsumer != null) {
                        this.logMessageConsumer.accept(McpLogMessage.fromJson(message.get("params")));
                    }
                } else {
                    log.warn("Received log message without params: {}", (Object)message);
                }
            } else if (method.equals("notifications/tools/list_changed")) {
                this.onToolListUpdate.run();
            } else {
                log.warn("Received unknown message: {}", (Object)message);
            }
        }
    }

    public void startOperation(Long id, CompletableFuture<JsonNode> future) {
        this.pendingOperations.put(id, future);
    }
}

