/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.url;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLDList {
    private static final Logger logger = LoggerFactory.getLogger(TLDList.class);
    private static final String TLD_NAMES_ONLINE_URL = "https://publicsuffix.org/list/public_suffix_list.dat";
    private static final String TLD_NAMES_TXT_FILENAME = "tld-names.txt";
    private static boolean onlineUpdate = false;
    private static String url = "https://publicsuffix.org/list/public_suffix_list.dat";
    private final java.util.function.Supplier<Set<String>> memoizer = () -> ((Supplier)Suppliers.memoize(TLDList::tldSupplier)).get();

    public static TLDList getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private TLDList() {
    }

    private static int readStream(InputStream stream, Set<String> tldSet) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("//")) continue;
                tldSet.add(line);
            }
        }
        catch (IOException e) {
            logger.warn("Error while reading TLD-list: {}", (Object)e.getMessage());
        }
        return tldSet.size();
    }

    public static void setUseOnline(boolean online) {
        TLDList.setUseOnline(online, TLD_NAMES_ONLINE_URL);
    }

    protected static void setUseOnline(boolean online, String downloadFromUrl) {
        onlineUpdate = online;
        url = downloadFromUrl;
    }

    public boolean contains(String str) {
        return this.memoizer.get().contains(str);
    }

    private static Set<String> tldSupplier() {
        HashSet<String> tldSet = new HashSet<String>(10000);
        if (onlineUpdate) {
            try (InputStream in = new URL(url).openStream();){
                logger.debug("Fetching the most updated TLD list online");
                int n = TLDList.readStream(in, tldSet);
                logger.info("Obtained {} TLD from URL {}", (Object)n, (Object)url);
            }
            catch (Exception e) {
                logger.error("Couldn't fetch the online list of TLDs from: {}", (Object)url, (Object)e);
                logger.error("Will try to load from file(s).");
                TLDList.loadFromFiles(tldSet);
            }
        } else {
            TLDList.loadFromFiles(tldSet);
        }
        return tldSet;
    }

    private static void loadFromFiles(Set<String> tldSet) {
        int n2;
        Throwable throwable;
        InputStream tldFile;
        try {
            tldFile = FileUtils.openInputStream((File)new File(TLD_NAMES_TXT_FILENAME));
            throwable = null;
            try {
                logger.debug("Fetching the list from a local file {}", (Object)TLD_NAMES_TXT_FILENAME);
                n2 = TLDList.readStream(tldFile, tldSet);
                logger.info("Obtained {} TLD from local file {}", (Object)n2, (Object)TLD_NAMES_TXT_FILENAME);
            }
            catch (Throwable n2) {
                throwable = n2;
                throw n2;
            }
            finally {
                if (tldFile != null) {
                    if (throwable != null) {
                        try {
                            tldFile.close();
                        }
                        catch (Throwable n2) {
                            throwable.addSuppressed(n2);
                        }
                    } else {
                        tldFile.close();
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.info("File not found: {}", (Object)TLD_NAMES_TXT_FILENAME);
        }
        catch (IOException e) {
            logger.error("Couldn't read the TLD list from file {}", (Object)TLD_NAMES_TXT_FILENAME);
        }
        try {
            tldFile = TLDList.class.getClassLoader().getResourceAsStream(TLD_NAMES_TXT_FILENAME);
            throwable = null;
            try {
                n2 = TLDList.readStream(tldFile, tldSet);
                logger.info("Obtained {} TLD from packaged file {}", (Object)n2, (Object)TLD_NAMES_TXT_FILENAME);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tldFile != null) {
                    if (throwable != null) {
                        try {
                            tldFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tldFile.close();
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Couldn't read the TLD list from file");
            throw new RuntimeException(e);
        }
    }

    private static class SingletonHolder {
        private static final TLDList INSTANCE = new TLDList();

        private SingletonHolder() {
        }
    }
}

