/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.crawler4j.util;

public class Util {
    public static byte[] long2ByteArray(long l) {
        byte[] array = new byte[8];
        int i = 0;
        int shift = 56;
        while (i < 8) {
            array[i] = (byte)(0xFFL & l >> shift);
            ++i;
            shift -= 8;
        }
        return array;
    }

    public static byte[] int2ByteArray(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (3 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
        }
        return b;
    }

    public static void putIntInByteArray(int value, byte[] buf, int offset) {
        for (int i = 0; i < 4; ++i) {
            int valueOffset = (3 - i) * 8;
            buf[offset + i] = (byte)(value >>> valueOffset & 0xFF);
        }
    }

    public static int byteArray2Int(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }

    public static long byteArray2Long(byte[] b) {
        int value = 0;
        for (int i = 0; i < 8; ++i) {
            int shift = (7 - i) * 8;
            value += (b[i] & 0xFF) << shift;
        }
        return value;
    }

    public static boolean hasBinaryContent(String contentType) {
        String typeStr = contentType != null ? contentType.toLowerCase() : "";
        return typeStr.contains("image") || typeStr.contains("audio") || typeStr.contains("video") || typeStr.contains("application");
    }

    public static boolean hasPlainTextContent(String contentType) {
        String typeStr = contentType != null ? contentType.toLowerCase() : "";
        return typeStr.contains("text") && !typeStr.contains("html");
    }
}

