/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.devtools;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import eu.cedarsoft.devtools.DirectorySupport;
import eu.cedarsoft.devtools.OldUrlNotFoundException;
import eu.cedarsoft.devtools.SubversionBin;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;

@Singleton
public class SubversionSupport {
    @NonNls
    public static final String PROPERTY_SUBVERSION_BIN = "subversionBin";
    @NonNls
    public static final String PROPERTY_REPOSITORY_URLS = "repositoryUrls";
    @NonNls
    public static final String PROPERTY_OLD_REPOSITORY_URLS = "oldRepositoryUrls";
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    @NotNull
    private final List<String> repositoryUrls = new ArrayList<String>();
    @NotNull
    @NonNls
    private final String subversionBin;
    @NotNull
    private final DirectorySupport directorySupport;
    @NotNull
    private final Map<String, String> oldRepositoryUrls = new HashMap<String, String>();

    @Inject
    public SubversionSupport(@NotNull DirectorySupport directorySupport, @SubversionBin @NotNull String subversionBin) {
        this.directorySupport = directorySupport;
        this.subversionBin = subversionBin;
    }

    @NotNull
    public ISVNAuthenticationManager getAuthenticationManager() {
        return new DefaultSVNAuthenticationManager(null, true, null, null);
    }

    @NotNull
    @NonNls
    public String getSubversionBin() {
        return this.subversionBin;
    }

    @NotNull
    @NonNls
    public List<String> getRepositoryUrls() {
        return Collections.unmodifiableList(this.repositoryUrls);
    }

    public void setRepositoryUrls(@NonNls @NotNull List<String> repositoryUrls) {
        ArrayList<String> old = new ArrayList<String>(repositoryUrls);
        this.repositoryUrls.clear();
        this.repositoryUrls.addAll(repositoryUrls);
        this.pcs.firePropertyChange(PROPERTY_REPOSITORY_URLS, old, repositoryUrls);
    }

    public void addRepositoryUrl(@NotNull @NonNls String repositoryUrl) {
        if (this.repositoryUrls.contains(repositoryUrl)) {
            return;
        }
        ArrayList<String> old = new ArrayList<String>(this.repositoryUrls);
        this.repositoryUrls.add(repositoryUrl);
        this.pcs.firePropertyChange(PROPERTY_REPOSITORY_URLS, old, this.repositoryUrls);
    }

    public void setOldRepositoryUrls(@NotNull Map<String, String> oldRepositoryUrls) {
        HashMap<String, String> old = new HashMap<String, String>(this.oldRepositoryUrls);
        this.oldRepositoryUrls.clear();
        this.oldRepositoryUrls.putAll(oldRepositoryUrls);
        this.pcs.firePropertyChange(PROPERTY_OLD_REPOSITORY_URLS, old, this.oldRepositoryUrls);
    }

    public void addOldRepositoryUrl(@NotNull @NonNls String oldUrl, @NotNull @NonNls String newUrl) {
        if (!this.repositoryUrls.contains(newUrl)) {
            throw new IllegalArgumentException("Invalid newUrl \"" + newUrl + "\"");
        }
        HashMap<String, String> old = new HashMap<String, String>(this.oldRepositoryUrls);
        this.oldRepositoryUrls.put(oldUrl, newUrl);
        this.pcs.firePropertyChange(PROPERTY_OLD_REPOSITORY_URLS, old, this.oldRepositoryUrls);
    }

    @NotNull
    public Map<String, String> getOldRepositoryUrls() {
        return Collections.unmodifiableMap(this.oldRepositoryUrls);
    }

    @NotNull
    @NonNls
    public String getCorrespondingNewUrl(@NotNull @NonNls String oldUrl) throws OldUrlNotFoundException {
        String newUrl = this.oldRepositoryUrls.get(oldUrl);
        if (newUrl == null) {
            throw new OldUrlNotFoundException("No new URL found for " + oldUrl);
        }
        return newUrl;
    }

    @NotNull
    public String getCorrespondingNewUrl(@NotNull SVNURL actualUrl) throws OldUrlNotFoundException {
        return this.getCorrespondingNewUrl(actualUrl.toString());
    }

    @NotNull
    public String guessImportName(@NotNull File dirToImport) throws IOException {
        if (!dirToImport.exists()) {
            throw new IllegalArgumentException("File does not exist: " + dirToImport.getCanonicalPath());
        }
        if (!dirToImport.isDirectory()) {
            throw new IllegalArgumentException("File ist not a directory " + dirToImport.getCanonicalPath());
        }
        if (this.directorySupport.isInProjectRoot(dirToImport)) {
            String path = this.directorySupport.getProjectSubPath(dirToImport);
            return path.replaceAll("/", ".");
        }
        return dirToImport.getCanonicalFile().getName();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @NotNull
    public DirectorySupport getDirectorySupport() {
        return this.directorySupport;
    }

    static {
        SVNRepositoryFactoryImpl.setup();
        DAVRepositoryFactory.setup();
        FSRepositoryFactory.setup();
    }
}

