/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.devtools.modules;

import com.google.inject.Inject;
import eu.cedarsoft.devtools.Module;
import eu.cedarsoft.devtools.SubversionMessageHandler;
import eu.cedarsoft.devtools.SubversionSupport;
import eu.cedarsoft.utils.CmdLine;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class AddExternalsDefinition
implements Module {
    @NotNull
    private final SubversionSupport subversionSupport;

    @Inject
    public AddExternalsDefinition(@NotNull SubversionSupport subversionSupport) {
        this.subversionSupport = subversionSupport;
    }

    @NotNull
    public String getDescription() {
        return SubversionMessageHandler.get("module.add.external.definition");
    }

    public void process(final @NotNull CmdLine cmdLine) throws Exception {
        String propertyValue;
        cmdLine.out(SubversionMessageHandler.get("module.add.external.definition"), new Object[0]);
        SVNClientManager manager = SVNClientManager.newInstance();
        File currentDir = new File(".");
        SVNPropertyData property = manager.getWCClient().doGetProperty(currentDir, "svn:externals", SVNRevision.WORKING, SVNRevision.WORKING, false);
        if (property != null) {
            String[] lines;
            propertyValue = property.getValue();
            cmdLine.out(SubversionMessageHandler.get("current.external.definitions"), new Object[0]);
            for (String line : lines = propertyValue.split("\n")) {
                String[] parts = line.split(" ");
                if (parts.length != 2) continue;
                cmdLine.out(SubversionMessageHandler.get("external.definition", parts[0].trim(), parts[1].trim()), new Object[0]);
            }
        } else {
            cmdLine.out(SubversionMessageHandler.get("no.current.external.definitions"), new Object[0]);
            propertyValue = "";
        }
        cmdLine.outNl();
        cmdLine.out(SubversionMessageHandler.get("adding.external.definition"), new Object[0]);
        String directory = cmdLine.read(SubversionMessageHandler.get("enter.directory"));
        cmdLine.outNl();
        String repository = cmdLine.read(SubversionMessageHandler.get("enter.svn.url"), this.subversionSupport.getRepositoryUrls());
        String path = cmdLine.read(SubversionMessageHandler.get("enter.path", repository));
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String url = repository + path;
        cmdLine.outNl();
        cmdLine.out(SubversionMessageHandler.get("will.add.external.definition.directory.url"), new Object[]{directory, url});
        cmdLine.pause(3);
        String newPropertyValue = propertyValue.trim() + "\n" + directory + " " + url;
        manager.getWCClient().doSetProperty(currentDir, "svn:externals", newPropertyValue.trim() + "\n", false, false, new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                this.debug(path.getAbsolutePath(), property.getName(), property.getValue());
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                this.debug(url.getURIEncodedPath(), property.getName(), property.getValue());
            }

            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            }

            public void debug(@NotNull String path, @NotNull String name, @NotNull String value) {
                cmdLine.out(SubversionMessageHandler.get("setting.property.path", path, name, value), new Object[0]);
            }
        });
    }
}

