/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.devtools.modules;

import eu.cedarsoft.devtools.FileTools;
import eu.cedarsoft.devtools.Module;
import eu.cedarsoft.devtools.SubversionMessageHandler;
import eu.cedarsoft.utils.CmdLine;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class IgnoreFileModule
implements Module {
    @NotNull
    public String getDescription() {
        return SubversionMessageHandler.get("module.ignore.file");
    }

    public void process(final @NotNull CmdLine cmdLine) throws Exception {
        String propertyValue;
        cmdLine.out(SubversionMessageHandler.get("module.edit.ignore"), new Object[0]);
        final SVNClientManager manager = SVNClientManager.newInstance();
        File currentDir = new File(".");
        SVNPropertyData property = manager.getWCClient().doGetProperty(currentDir, "svn:ignore", SVNRevision.WORKING, SVNRevision.WORKING, false);
        final HashSet<String> ignored = new HashSet<String>();
        if (property != null) {
            String[] lines;
            propertyValue = property.getValue();
            cmdLine.out(SubversionMessageHandler.get("current.ignore"), new Object[0]);
            for (String line : lines = propertyValue.trim().split("\n")) {
                cmdLine.out(SubversionMessageHandler.get("ignored.file", line), new Object[0]);
            }
            ignored.addAll(Arrays.asList(lines));
        } else {
            cmdLine.out(SubversionMessageHandler.get("no.current.ignored"), new Object[0]);
            propertyValue = "";
        }
        cmdLine.outNl();
        File fileToIgnore = FileTools.readFile((CmdLine)cmdLine, (String)SubversionMessageHandler.get("select.file.to.ignore"), (File[])currentDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().equals(".svn")) {
                    return false;
                }
                try {
                    SVNInfo info = manager.getWCClient().doInfo(pathname, SVNRevision.HEAD);
                    if (info != null) {
                        return false;
                    }
                    return !ignored.contains(pathname.getName());
                }
                catch (SVNException ignore) {
                    return true;
                }
            }
        }));
        cmdLine.out(SubversionMessageHandler.get("will.ignore.file", fileToIgnore.getAbsolutePath()), new Object[0]);
        cmdLine.pause(3);
        String newPropertyValue = propertyValue.trim() + "\n" + fileToIgnore.getName();
        manager.getWCClient().doSetProperty(currentDir, "svn:ignore", newPropertyValue.trim() + "\n", false, false, new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                this.debug(path.getAbsolutePath(), property.getName(), property.getValue());
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                this.debug(url.getURIEncodedPath(), property.getName(), property.getValue());
            }

            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            }

            public void debug(@NotNull String path, @NotNull String name, @NotNull String value) {
                cmdLine.out(SubversionMessageHandler.get("setting.property.path", path, name, value), new Object[0]);
            }
        });
    }
}

