/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.devtools.modules;

import com.google.inject.Inject;
import eu.cedarsoft.devtools.Module;
import eu.cedarsoft.devtools.SubversionMessageHandler;
import eu.cedarsoft.devtools.SubversionSupport;
import eu.cedarsoft.utils.CmdLine;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class ListRepositoryEntries
implements Module {
    @NotNull
    private final SubversionSupport subversionSupport;

    @Inject
    public ListRepositoryEntries(@NotNull SubversionSupport subversionSupport) {
        this.subversionSupport = subversionSupport;
    }

    @NotNull
    public String getDescription() {
        return SubversionMessageHandler.get("module.list.repository.entries");
    }

    public void process(@NotNull CmdLine cmdLine) throws IOException, SVNException {
        cmdLine.out(SubversionMessageHandler.get("module.list.repository.entries"), new Object[0]);
        String repositoryUrl = cmdLine.read(SubversionMessageHandler.get("wich.repository.shall.be.used"), this.subversionSupport.getRepositoryUrls(), null);
        this.subversionSupport.addRepositoryUrl(repositoryUrl);
        cmdLine.warning(SubversionMessageHandler.get("listing.repository.entries"), new Object[0]);
        cmdLine.out(SubversionMessageHandler.get("repository"), new Object[0]);
        cmdLine.success('\t' + repositoryUrl, new Object[0]);
        SVNURL svnurl = SVNURL.parseURIDecoded((String)repositoryUrl);
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)svnurl);
        repository.setAuthenticationManager(this.subversionSupport.getAuthenticationManager());
        Collection dirEntry = repository.getDir(".", repository.getLatestRevision(), null, (Collection)null);
        for (SVNDirEntry entry : dirEntry) {
            cmdLine.out(entry.getRelativePath() + "\t\t(" + entry.getKind() + ")", new Object[0]);
        }
    }
}

