/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.devtools.modules;

import com.google.inject.Inject;
import eu.cedarsoft.devtools.DirectorySupport;
import eu.cedarsoft.devtools.Module;
import eu.cedarsoft.devtools.SubversionMessageHandler;
import eu.cedarsoft.devtools.SubversionSupport;
import eu.cedarsoft.utils.CmdLine;
import eu.cedarsoft.utils.io.FileCopyManager;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class SubversionImportModule
implements Module {
    @NotNull
    private final SubversionSupport subversionSupport;

    @Inject
    public SubversionImportModule(@NotNull SubversionSupport subversionSupport) {
        this.subversionSupport = subversionSupport;
    }

    @NotNull
    public String getDescription() {
        return SubversionMessageHandler.get("module.subversion.import");
    }

    public void process(@NotNull CmdLine cmdLine) throws IOException {
        cmdLine.out(SubversionMessageHandler.get("import.directory.into.subversion"), new Object[0]);
        File current = new File(".");
        String importName = cmdLine.read(SubversionMessageHandler.get("select.import.name"), this.subversionSupport.guessImportName(current));
        String repositoryUrl = cmdLine.read(SubversionMessageHandler.get("wich.repository.shall.be.used"), this.subversionSupport.getRepositoryUrls(), null);
        this.subversionSupport.addRepositoryUrl(repositoryUrl);
        File svnDir = new File(current, ".svn");
        if (svnDir.exists()) {
            throw new IllegalStateException(current.getCanonicalPath() + " is still in svn");
        }
        cmdLine.warning(SubversionMessageHandler.get("importing.directory.subversion"), new Object[0]);
        cmdLine.out(SubversionMessageHandler.get("import.name"), new Object[0]);
        cmdLine.success('\t' + importName, new Object[0]);
        cmdLine.out(SubversionMessageHandler.get("repository.url"), new Object[0]);
        cmdLine.success('\t' + repositoryUrl, new Object[0]);
        cmdLine.pause(5);
        File tmpDir = this.createTmpDir();
        File proj = new File(tmpDir, importName);
        proj.mkdir();
        File trunk = new File(proj, "trunk");
        trunk.mkdir();
        new File(proj, "branches").mkdir();
        new File(proj, "tags").mkdir();
        cmdLine.out(SubversionMessageHandler.get("importing.project"), new Object[0]);
        Process process = Runtime.getRuntime().exec(this.subversionSupport.getSubversionBin() + " import . " + repositoryUrl + " --message 'Initial'", null, tmpDir);
        cmdLine.out(process);
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        FileCopyManager.deleteForced((File)tmpDir);
        tmpDir = this.createTmpDir();
        cmdLine.out(SubversionMessageHandler.get("checking.out.project"), new Object[0]);
        process = Runtime.getRuntime().exec(this.subversionSupport.getSubversionBin() + " checkout " + repositoryUrl + "/" + importName + "/trunk " + importName, null, tmpDir);
        cmdLine.out(process);
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        File checkedOut = new File(tmpDir, importName);
        File svnDir2 = new File(checkedOut, ".svn");
        File dstDir = new File(current, ".svn");
        dstDir.mkdir();
        FileCopyManager.copy((File)svnDir2, (File)dstDir);
        FileCopyManager.deleteForced((File)tmpDir);
        cmdLine.success(SubversionMessageHandler.get("module.processed.successfully"), new Object[0]);
    }

    protected File createTmpDir() {
        File tmpDir = new File(DirectorySupport.getTempDir(), "tmpDir");
        if (tmpDir.exists()) {
            throw new IllegalStateException("Uups. File still exists " + tmpDir.getAbsolutePath());
        }
        tmpDir.mkdir();
        return tmpDir;
    }
}

