/*
 * Decompiled with CFR 0.152.
 */
package eu.cedarsoft.devtools.modules;

import com.google.inject.Inject;
import eu.cedarsoft.devtools.Module;
import eu.cedarsoft.devtools.OldUrlNotFoundException;
import eu.cedarsoft.devtools.ProcessWrapper;
import eu.cedarsoft.devtools.SubversionMessageHandler;
import eu.cedarsoft.devtools.SubversionSupport;
import eu.cedarsoft.utils.CmdLine;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SwitchToNewUrlModule
implements Module {
    @NotNull
    private final SubversionSupport subversionSupport;

    @Inject
    public SwitchToNewUrlModule(@NotNull SubversionSupport subversionSupport) {
        this.subversionSupport = subversionSupport;
    }

    @NotNull
    public String getDescription() {
        return SubversionMessageHandler.get("module.switch.repository");
    }

    public void process(@NotNull CmdLine cmdLine) throws Exception {
        String newUrl;
        SVNClientManager manager = SVNClientManager.newInstance();
        File current = new File(".");
        SVNWCClient client = manager.getWCClient();
        SVNInfo info = client.doInfo(current.getCanonicalFile(), SVNRevision.WORKING);
        if (info == null) {
            throw new IllegalStateException("No info found for " + current.getCanonicalPath());
        }
        SVNURL actualUrl = info.getRepositoryRootURL();
        try {
            newUrl = this.subversionSupport.getCorrespondingNewUrl(actualUrl);
        }
        catch (OldUrlNotFoundException ignore) {
            newUrl = cmdLine.read(SubversionMessageHandler.get("enter.new.url.for", actualUrl.toString()), "");
            this.subversionSupport.addRepositoryUrl(newUrl);
            this.subversionSupport.addOldRepositoryUrl(actualUrl.toString(), newUrl);
        }
        cmdLine.out(SubversionMessageHandler.get("module.switch.relocating", actualUrl, newUrl), new Object[0]);
        cmdLine.pause(5);
        String command = this.subversionSupport.getSubversionBin() + " switch --relocate " + actualUrl + " " + newUrl;
        cmdLine.out("---> " + command, new Object[0]);
        ProcessWrapper.runCommand((CmdLine)cmdLine, (String)command);
        cmdLine.success(SubversionMessageHandler.get("module.processed.successfully"), new Object[0]);
    }
}

