/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.aspect;

import com.els.common.aspect.annotation.SrmTransaction;
import io.seata.core.exception.TransactionException;
import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;
import io.seata.tm.api.TransactionalExecutor;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SrmTransactionAspect {
    private static final Logger log = LoggerFactory.getLogger(SrmTransactionAspect.class);

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.SrmTransaction)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object object;
        log.info("SrmTransactionAspect srmTransactionAspect : ");
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        SrmTransaction srmTransaction = method.getAnnotation(SrmTransaction.class);
        GlobalTransaction gt = GlobalTransactionContext.getCurrentOrCreate();
        log.info("\u5f00\u59cb\u4e8b\u6216\u5f53\u524d\u4e8b\u52a1ID\u4e3a\uff1a{}" + gt.getXid());
        try {
            if (gt.getStatus().getCode() > 0) {
                return point.proceed();
            }
        }
        catch (TransactionException e) {
            log.error("\u83b7\u53d6\u4e8b\u52a1\u72b6\u6001\u5931\u8d25:", (Throwable)e);
            return point.proceed();
        }
        try {
            gt.begin(srmTransaction.timeout() * 60000);
        }
        catch (TransactionException e) {
            throw new TransactionalExecutor.ExecutionException(gt, (Throwable)e, TransactionalExecutor.Code.BeginFailure);
        }
        try {
            object = point.proceed();
        }
        catch (Throwable e) {
            this.rollback(gt, e);
            try {
                gt.commit();
            }
            catch (TransactionException ex) {
                throw new TransactionalExecutor.ExecutionException(gt, (Throwable)ex, TransactionalExecutor.Code.CommitFailure);
            }
            throw e;
        }
        try {
            gt.commit();
        }
        catch (TransactionException e) {
            throw new TransactionalExecutor.ExecutionException(gt, (Throwable)e, TransactionalExecutor.Code.CommitFailure);
        }
        return object;
    }

    private void rollback(GlobalTransaction gt, Throwable e) throws Throwable {
        try {
            gt.rollback();
            throw e;
        }
        catch (TransactionException ex) {
            throw e;
        }
    }
}

