/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.util.UrlPathHelper;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;

public class SwaggerUtil {
    public static SimpleUrlHandlerMapping getSimpleUrlHandlerMapping(ServletContext servletContext, String projectPath) throws Exception {
        SimpleUrlHandlerMapping urlHandlerMapping = new SimpleUrlHandlerMapping();
        HashMap<String, ResourceHttpRequestHandler> urlMap = new HashMap<String, ResourceHttpRequestHandler>();
        PathResourceResolver pathResourceResolver = new PathResourceResolver();
        pathResourceResolver.setAllowedLocations(new Resource[]{new ClassPathResource("META-INF/resources/webjars/")});
        pathResourceResolver.setUrlPathHelper(new UrlPathHelper());
        ResourceHttpRequestHandler resourceHttpRequestHandler = new ResourceHttpRequestHandler();
        resourceHttpRequestHandler.setLocations(Collections.singletonList(new ClassPathResource("META-INF/resources/webjars/")));
        resourceHttpRequestHandler.setResourceResolvers(Collections.singletonList(pathResourceResolver));
        resourceHttpRequestHandler.setServletContext(servletContext);
        resourceHttpRequestHandler.afterPropertiesSet();
        urlMap.put(projectPath + "/webjars/**", resourceHttpRequestHandler);
        pathResourceResolver = new PathResourceResolver();
        pathResourceResolver.setAllowedLocations(new Resource[]{new ClassPathResource("META-INF/resources/")});
        pathResourceResolver.setUrlPathHelper(new UrlPathHelper());
        resourceHttpRequestHandler = new ResourceHttpRequestHandler();
        resourceHttpRequestHandler.setLocations(Collections.singletonList(new ClassPathResource("META-INF/resources/")));
        resourceHttpRequestHandler.setResourceResolvers(Collections.singletonList(pathResourceResolver));
        resourceHttpRequestHandler.setServletContext(servletContext);
        resourceHttpRequestHandler.afterPropertiesSet();
        urlMap.put(projectPath + "/**", resourceHttpRequestHandler);
        urlHandlerMapping.setUrlMap(urlMap);
        urlHandlerMapping.setOrder(1);
        return urlHandlerMapping;
    }

    public static ApiInfo getApiInfo() {
        return new ApiInfoBuilder().title("SRM \u540e\u53f0\u670d\u52a1API\u63a5\u53e3\u6587\u6863").version("1.0").description("\u540e\u53f0API\u63a5\u53e3").contact(new Contact("ELS\u56e2\u961f", "", "")).license("The Apache License, Version 2.0").licenseUrl("http://www.apache.org/licenses/LICENSE-2.0.html").build();
    }

    public static List<Parameter> setHeaderToken() {
        ParameterBuilder tokenPar = new ParameterBuilder();
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        tokenPar.name("X-Access-Token").description("token").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build();
        pars.add(tokenPar.build());
        return pars;
    }
}

