/*
 * Decompiled with CFR 0.152.
 */
package com.els.dubbo.filter;

import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.dubbo.trace.DubboTraceType;
import com.els.dubbo.trace.DubboTraceUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"})
public class ConsumerTraceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ConsumerTraceFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        invocation.setAttachment("loginUser", (Object)SysUtil.getLoginUser());
        invocation.setAttachment("language", I18nUtil.getCurrentLanguage());
        invocation.setAttachment("adminFlag", AdminFlagUtil.getAdminFlag());
        log.debug(":::ConsumerTraceFilter before{}", (Object)SysUtil.getLoginUser());
        DubboTraceUtils.traceDubbo(invocation, DubboTraceType.CONSUMER);
        Result invoke = invoker.invoke(invocation);
        log.debug(":::ConsumerTraceFilter after{}", (Object)SysUtil.getLoginUser());
        return invoke;
    }
}

