/*
 * Decompiled with CFR 0.152.
 */
package com.els.dubbo.filter;

import com.els.common.system.vo.LoginUser;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.config.mybatis.TenantContext;
import com.els.dubbo.trace.DubboTraceType;
import com.els.dubbo.trace.DubboTraceUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class ProviderTraceFilter
implements Filter {
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Result result;
        LoginUser user = (LoginUser)invocation.getObjectAttachment("loginUser");
        I18nUtil.setCurrentLanguage((String)((String)invocation.getObjectAttachment("language")));
        AdminFlagUtil.setAdminFlag((String)((String)invocation.getObjectAttachment("adminFlag")));
        if (user != null) {
            LoginUserContext.setUser((LoginUser)user);
            TenantContext.setTenant((String)user.getElsAccount());
            DubboTraceUtils.traceDubbo(invocation, DubboTraceType.PROVIDER);
            result = invoker.invoke(invocation);
            LoginUserContext.clear();
            I18nUtil.clear();
        } else {
            result = invoker.invoke(invocation);
        }
        return result;
    }
}

