/*
 * Decompiled with CFR 0.152.
 */
package com.els.dubbo.trace;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.context.BusAccountHolder;
import com.els.common.trace.TraceIdHolder;
import com.els.dubbo.trace.DubboTraceType;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.RpcInvocation;

public class DubboTraceUtils {
    private static final String X_COMMON_TRACE_ID = "ELS-COMMON-TRACE-ID";
    private static final String X_COMMON_BUS_ACCOUNT = "ELS-COMMON-BUS_ACCOUNT";

    public static void traceDubbo(Invocation invocation, DubboTraceType type) {
        switch (type) {
            case CONSUMER: {
                RpcInvocation rpcInvocation = (RpcInvocation)invocation;
                String traceId = TraceIdHolder.get();
                rpcInvocation.setAttachment(X_COMMON_TRACE_ID, traceId);
                String busAccount = BusAccountHolder.get();
                if (!CharSequenceUtil.isNotBlank((CharSequence)busAccount)) break;
                rpcInvocation.setAttachment(X_COMMON_BUS_ACCOUNT, busAccount);
                break;
            }
            case PROVIDER: {
                String traceId = invocation.getAttachment(X_COMMON_TRACE_ID);
                TraceIdHolder.set((String)traceId);
                String busAccount = invocation.getAttachment(X_COMMON_BUS_ACCOUNT);
                if (!CharSequenceUtil.isNotBlank((CharSequence)busAccount)) break;
                BusAccountHolder.set((String)busAccount);
                break;
            }
        }
    }
}

