/*
 * Decompiled with CFR 0.152.
 */
package com.els.rpc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.account.api.dto.ElsTenantDTO;
import com.els.modules.account.api.dto.InterfaceAppDTO;
import com.els.modules.account.api.dto.JustAuthConfigDTO;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.dto.PermissionDTO;
import com.els.modules.account.api.dto.PermissionDataDTO;
import com.els.modules.account.api.dto.PermissionSensitiveFieldDTO;
import com.els.modules.account.api.dto.PersonalSettingDTO;
import com.els.modules.account.api.dto.SubAccountOrgDTO;
import com.els.modules.account.api.dto.ThirdAccountDTO;
import com.els.modules.account.api.dto.ThirdAuthDTO;
import com.els.modules.account.api.service.AccountRpcService;
import com.els.modules.account.api.service.InterfaceAppPermissionRpcService;
import com.els.modules.account.api.service.InterfaceAppRpcService;
import com.els.modules.account.api.service.JustAuthConfigRpcService;
import com.els.modules.account.api.service.SubAccountOrgRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="coreInvokeAccountServiceImpl")
public class CoreInvokeAccountDubboServiceImpl
implements InvokeAccountRpcService {
    @DubboReference
    @Lazy
    private AccountRpcService accountDubboService;
    @DubboReference
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @DubboReference
    private JustAuthConfigRpcService justAuthConfigRpcService;
    @DubboReference
    @Lazy
    private SubAccountOrgRpcService subAccountOrgRpcService;
    @DubboReference
    private InterfaceAppRpcService interfaceAppRpcService;
    @DubboReference
    private InterfaceAppPermissionRpcService interfaceAppPermissionRpcService;

    public List<ThirdAccountDTO> getThirdAccount(String accountId, String thirdType) {
        return this.accountDubboService.getThirdAccount(accountId, thirdType);
    }

    public List<PersonalSettingDTO> getPersonalSetting(String elsAccount, String subAccount) {
        return this.accountDubboService.getPersonalSetting(elsAccount, subAccount);
    }

    public ElsSubAccountDTO getAccount(String elsAccount, String subAccount) {
        return this.accountDubboService.getAccount(elsAccount, subAccount);
    }

    public ElsSubAccountDTO getAccountById(String id) {
        return this.accountDubboService.getAccountById(id);
    }

    public List<ElsSubAccountDTO> getAccountById(List<String> ids) {
        return this.accountDubboService.getAccountById(ids);
    }

    public List<ElsSubAccountDTO> getAccountByRoles(String elsAccount, List<String> roles) {
        return this.accountDubboService.getAccountByRoles(elsAccount, roles);
    }

    public LoginUserDTO getLoginUser(String account) {
        return this.accountDubboService.getLoginUser(account);
    }

    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        return this.accountDubboService.getUserRolesSet(elsAccount, subAccount);
    }

    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        return this.accountDubboService.getUserPermissionsSet(elsAccount, subAccount);
    }

    public Set<String> getAllOptPermission() {
        return this.accountDubboService.getAllOptPermission();
    }

    public List<PermissionDataDTO> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        return this.accountDubboService.getPermissionDataList(elsAccount, subAccount, businessType);
    }

    public List<ElsSubAccountDTO> getAccountList(String elsAccount, List<String> subAccounts) {
        return this.accountDubboService.getAccountList(elsAccount, subAccounts);
    }

    public ElsEnterpriseInfoDTO getByElsAccount(String elsAccount) {
        return this.elsEnterpriseInfoRpcService.getByElsAccount(elsAccount);
    }

    public ThirdAuthDTO getThirdAuthByType(String elsAccount, String appType) {
        return this.accountDubboService.getThirdAuthByType(elsAccount, appType);
    }

    public JSONArray getMenuJsonArray(String elsAccount, String subAccount, Integer mobile) {
        return this.accountDubboService.getMenuJsonArray(elsAccount, subAccount, mobile);
    }

    public JustAuthConfigDTO getOneConfig(String elsAccount, String authType) {
        return this.justAuthConfigRpcService.getOneConfig(elsAccount, authType);
    }

    public List<ElsTenantDTO> getTenantList(List<String> elsAccounts) {
        return this.accountDubboService.getTenantList(elsAccounts);
    }

    public List<String> getAccountListByLeader(String elsAccount, String subAccount) {
        return this.accountDubboService.getAccountListByLeader(elsAccount, subAccount);
    }

    public List<String> queryAllSubAccount(List<String> elsAccount) {
        return this.accountDubboService.queryAllSubAccount(elsAccount);
    }

    public List<SubAccountOrgDTO> getSubAccountOrgList(String userId) {
        return this.subAccountOrgRpcService.getSubAccountOrgList(userId);
    }

    public InterfaceAppDTO getApp(String appKey, String appSecret) {
        return this.interfaceAppRpcService.getApp(appKey, appSecret);
    }

    public Boolean checkAppPermission(String elsAccount, String appId, String interfaceCode) {
        return this.interfaceAppPermissionRpcService.checkAppPermission(elsAccount, appId, interfaceCode);
    }

    public List<PermissionDataDTO> getPermissionDataList(String userId, String businessType) {
        return this.accountDubboService.getPermissionDataList(userId, businessType);
    }

    public Map<String, String> getUserOrg(String userId) {
        return this.subAccountOrgRpcService.getUserOrg(userId);
    }

    public List<PermissionDTO> getPermissionByAccount(String elsAccount, String subAccount) {
        return this.accountDubboService.getPermissionByAccount(elsAccount, subAccount);
    }

    public List<PermissionSensitiveFieldDTO> getPermissionSensitiveFieldList(String userId, String businessType) {
        return this.accountDubboService.getPermissionSensitiveFieldList(userId, businessType);
    }

    public List<PermissionSensitiveFieldDTO> getPermissionSensitiveFieldList(String userId) {
        return this.accountDubboService.getPermissionSensitiveFieldList(userId);
    }
}

