/*
 * Decompiled with CFR 0.152.
 */
package com.els.rpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.other.api.dto.LicenseDTO;
import com.els.modules.other.api.service.OtherRpcService;
import com.els.modules.workorder.api.dto.WorkOrderHeadDTO;
import com.els.modules.workorder.api.service.WorkOrderRpcService;
import com.els.rpc.service.CoreInvokeOtherRpcService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.reflections.Reflections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CoreInvokeOtherDubboServiceImpl
implements CoreInvokeOtherRpcService {
    @DubboReference
    private WorkOrderRpcService workOrderRpcService;
    @DubboReference
    private OtherRpcService otherRpcService;
    @Autowired
    private RedisUtil redisUtil;

    public void createWorkorder(WorkOrderHeadDTO headDTO) {
        this.workOrderRpcService.createWorkOrder(headDTO);
    }

    public LicenseDTO getLicenseInfo() {
        String key = "sys:thirdAuth:licenseInfo:" + SysUtil.getPurchaseAccount();
        LicenseDTO dto = (LicenseDTO)this.redisUtil.get(key);
        if (null != dto) {
            Reflections.log.info("\u5f53\u524dlicense\u914d\u7f6e1\uff1a" + JSONObject.toJSONString((Object)dto));
            return dto;
        }
        dto = this.otherRpcService.getLicenseInfo();
        if (null != dto) {
            Reflections.log.info("\u5f53\u524dlicense\u914d\u7f6e2\uff1a" + JSONObject.toJSONString((Object)dto));
            this.redisUtil.set(key, (Object)dto, 86400L);
        }
        return dto;
    }

    public JSONObject callPanshi(String interfaceCode, JSONObject body) {
        return this.otherRpcService.callPanshi(interfaceCode, body);
    }
}

