/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm;

import com.security.gm.Utils;
import java.security.MessageDigest;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Hex;
import sun.misc.BASE64Encoder;

public class SM3Utils {
    private static final String CHARSET = "UTF-8";
    private static final String DEFAULT_XRO_KEY = "BC614E";

    public static String hexEncrypt(String hexString) {
        byte[] srcData = Hex.decode((String)hexString);
        byte[] encrypt = SM3Utils.encrypt(srcData);
        String cipherStr = Hex.toHexString((byte[])encrypt);
        return cipherStr;
    }

    public static String hexEncrypt(String hexKey, String hexString) {
        byte[] key = Hex.decode((String)hexKey);
        byte[] srcData = Hex.decode((String)hexString);
        byte[] encrypt = SM3Utils.encrypt(key, srcData);
        String cipherStr = Hex.toHexString((byte[])encrypt);
        return cipherStr;
    }

    public static String plainEncrypt(String plain) {
        String cipherStr = null;
        try {
            byte[] srcData = plain.getBytes(CHARSET);
            byte[] encrypt = SM3Utils.encrypt(srcData);
            cipherStr = Hex.toHexString((byte[])encrypt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cipherStr;
    }

    public static String plainEncrypt(String hexKey, String plain) {
        String cipherStr = null;
        try {
            byte[] srcData = plain.getBytes(CHARSET);
            byte[] key = Hex.decode((String)hexKey);
            byte[] encrypt = SM3Utils.encrypt(key, srcData);
            cipherStr = Hex.toHexString((byte[])encrypt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cipherStr;
    }

    public static byte[] encrypt(byte[] srcData) {
        SM3Digest sm3Digest = new SM3Digest();
        sm3Digest.update(srcData, 0, srcData.length);
        byte[] encrypt = new byte[sm3Digest.getDigestSize()];
        sm3Digest.doFinal(encrypt, 0);
        return encrypt;
    }

    public static byte[] hash(byte[] srcData) {
        return SM3Utils.encrypt(srcData);
    }

    public static byte[] encrypt(byte[] key, byte[] srcData) {
        KeyParameter keyParameter = new KeyParameter(key);
        SM3Digest digest = new SM3Digest();
        HMac mac = new HMac((Digest)digest);
        mac.init((CipherParameters)keyParameter);
        mac.update(srcData, 0, srcData.length);
        byte[] result = new byte[mac.getMacSize()];
        mac.doFinal(result, 0);
        return result;
    }

    public static byte[] encrypt_0(byte[] srcData) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("SM3", "BC");
        byte[] digest = messageDigest.digest(srcData);
        return digest;
    }

    public static byte[] encodexor(byte[] src, int xorkey) {
        int key = xorkey != 0 ? xorkey : Utils.hexStringToAlgorism(DEFAULT_XRO_KEY);
        byte[] tmp = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            tmp[i] = (byte)(src[i] ^ key);
            ++i;
        }
        return tmp;
    }

    public static byte[] hashXor(byte[] src) {
        byte[] srcData = new BASE64Encoder().encodeBuffer(src).replaceAll("\r\n", "").replaceAll("\n", "").getBytes();
        SM3Digest digest = new SM3Digest();
        digest.update(srcData, 0, srcData.length);
        byte[] hash = new byte[digest.getDigestSize()];
        digest.doFinal(hash, 0);
        byte[] xor = SM3Utils.encodexor(hash, src.length);
        System.arraycopy(hash, 0, hash, 0, hash.length / 2);
        System.arraycopy(xor, 0, hash, hash.length / 2, xor.length / 2);
        return ByteUtils.toHexString((byte[])hash).replaceAll("\n", "").getBytes();
    }

    public static void main(String[] args) {
        byte[] md = new byte[32];
        byte[] msg1 = "a".getBytes();
        System.out.println(Utils.byteToHex(SM3Utils.encrypt(msg1)));
    }
}

