/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Random;

public class Utils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] SOURCE_CHAR_ARR = new char[]{'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'Z', 'X', 'C', 'V', 'B', 'N', 'M', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm'};

    public static byte[] joinBytes(byte[] ... params) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] res = null;
        int i = 0;
        while (i < params.length) {
            baos.write(params[i]);
            ++i;
        }
        res = baos.toByteArray();
        return res;
    }

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num >> 0), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = (0xFF & bytes[0]) << 0;
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        int i = 0;
        while (i < 8) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
            ++i;
        }
        return bytes;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmpd = null;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmpd = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmpd, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmpd = n.toByteArray();
        } else {
            tmpd = new byte[32];
            int i = 0;
            while (i < 32 - n.toByteArray().length) {
                tmpd[i] = 0;
                ++i;
            }
            System.arraycopy(n.toByteArray(), 0, tmpd, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmpd;
    }

    public static BigInteger byteConvertInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static String getHexString(byte[] bytes) {
        return Utils.getHexString(bytes, true);
    }

    public static String getHexString(byte[] bytes, boolean upperCase) {
        String ret = "";
        int i = 0;
        while (i < bytes.length) {
            ret = String.valueOf(ret) + Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1);
            ++i;
        }
        return upperCase ? ret.toUpperCase() : ret;
    }

    public static void printHexString(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            System.out.print("0x" + hex.toUpperCase() + ",");
            ++i;
        }
        System.out.println("");
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(Utils.charToByte(hexChars[pos]) << 4 | Utils.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static char[] encodeHex(byte[] data) {
        return Utils.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Utils.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
            ++i;
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return Utils.encodeHexString(data, true);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return Utils.encodeHexString(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexString(byte[] data, char[] toDigits) {
        return new String(Utils.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Utils.toDigit(data[j], j) << 4;
            f |= Utils.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String StringToAsciiString(String content) {
        String result = "";
        int max = content.length();
        int i = 0;
        while (i < max) {
            char c = content.charAt(i);
            String b = Integer.toHexString(c);
            result = String.valueOf(result) + b;
            ++i;
        }
        return result;
    }

    public static String hexStringToString(String hexString, int encodeType) {
        String result = "";
        int max = hexString.length() / encodeType;
        int i = 0;
        while (i < max) {
            char c = (char)Utils.hexStringToAlgorism(hexString.substring(i * encodeType, (i + 1) * encodeType));
            result = String.valueOf(result) + c;
            ++i;
        }
        return result;
    }

    public static int hexStringToAlgorism(String hex) {
        hex = hex.toUpperCase();
        int max = hex.length();
        int result = 0;
        int i = max;
        while (i > 0) {
            char c = hex.charAt(i - 1);
            int algorism = 0;
            algorism = c >= '0' && c <= '9' ? c - 48 : c - 55;
            result = (int)((double)result + Math.pow(16.0, max - i) * (double)algorism);
            --i;
        }
        return result;
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        String result = "";
        int max = hex.length();
        int i = 0;
        while (i < max) {
            char c = hex.charAt(i);
            switch (c) {
                case '0': {
                    result = String.valueOf(result) + "0000";
                    break;
                }
                case '1': {
                    result = String.valueOf(result) + "0001";
                    break;
                }
                case '2': {
                    result = String.valueOf(result) + "0010";
                    break;
                }
                case '3': {
                    result = String.valueOf(result) + "0011";
                    break;
                }
                case '4': {
                    result = String.valueOf(result) + "0100";
                    break;
                }
                case '5': {
                    result = String.valueOf(result) + "0101";
                    break;
                }
                case '6': {
                    result = String.valueOf(result) + "0110";
                    break;
                }
                case '7': {
                    result = String.valueOf(result) + "0111";
                    break;
                }
                case '8': {
                    result = String.valueOf(result) + "1000";
                    break;
                }
                case '9': {
                    result = String.valueOf(result) + "1001";
                    break;
                }
                case 'A': {
                    result = String.valueOf(result) + "1010";
                    break;
                }
                case 'B': {
                    result = String.valueOf(result) + "1011";
                    break;
                }
                case 'C': {
                    result = String.valueOf(result) + "1100";
                    break;
                }
                case 'D': {
                    result = String.valueOf(result) + "1101";
                    break;
                }
                case 'E': {
                    result = String.valueOf(result) + "1110";
                    break;
                }
                case 'F': {
                    result = String.valueOf(result) + "1111";
                }
            }
            ++i;
        }
        return result;
    }

    public static String AsciiStringToString(String content) {
        String result = "";
        int length = content.length() / 2;
        int i = 0;
        while (i < length) {
            String c = content.substring(i * 2, i * 2 + 2);
            int a = Utils.hexStringToAlgorism(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result = String.valueOf(result) + d;
            ++i;
        }
        return result;
    }

    public static String algorismToHexString(int algorism, int maxLength) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return Utils.patchHexString(result.toUpperCase(), maxLength);
    }

    public static String byteToString(byte[] bytearray) {
        String result = "";
        int length = bytearray.length;
        int i = 0;
        while (i < length) {
            char temp = (char)bytearray[i];
            result = String.valueOf(result) + temp;
            ++i;
        }
        return result;
    }

    public static int binaryToAlgorism(String binary) {
        int max = binary.length();
        int result = 0;
        int i = max;
        while (i > 0) {
            char c = binary.charAt(i - 1);
            int algorism = c - 48;
            result = (int)((double)result + Math.pow(2.0, max - i) * (double)algorism);
            --i;
        }
        return result;
    }

    public static String algorismToHEXString(int algorism) {
        String result = "";
        result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String patchHexString(String str, int maxLength) {
        String temp = "";
        int i = 0;
        while (i < maxLength - str.length()) {
            temp = "0" + temp;
            ++i;
        }
        str = (String.valueOf(temp) + str).substring(0, maxLength);
        return str;
    }

    public static int parseToInt(String s, int defaultInt, int radix) {
        int i = 0;
        try {
            i = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static int parseToInt(String s, int defaultInt) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = new Integer(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        String hs = "";
        String stmp = "";
        int n = 0;
        while (n < b.length) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? String.valueOf(hs) + "0" + stmp : String.valueOf(hs) + stmp;
            ++n;
        }
        return hs.toUpperCase();
    }

    public static byte[] subByte(byte[] input, int startIndex, int length) {
        byte[] bt = new byte[length];
        int i = 0;
        while (i < length) {
            bt[i] = input[i + startIndex];
            ++i;
        }
        return bt;
    }

    public static String genRandomKey(int digit) {
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        int i = 0;
        while (i < digit) {
            sb.append(SOURCE_CHAR_ARR[random.nextInt(SOURCE_CHAR_ARR.length)]);
            ++i;
        }
        return sb.toString();
    }

    public static String int2HexStr(int number, int digit) throws RuntimeException {
        String str = String.format("%0" + digit + "x", number);
        if (str.length() > digit) {
            throw new RuntimeException("\u6570\u5b57" + number + "\u768416\u8fdb\u5236\u957f\u5ea6\u5927\u4e8e" + digit + "!!");
        }
        return str;
    }

    public static int hexStr2Int(String hex) {
        hex = hex.toUpperCase();
        int r = 0;
        int i = hex.length() - 1;
        while (i >= 0) {
            char c = hex.charAt(i);
            int algorism = 0;
            algorism = c >= '0' && c <= '9' ? c - 48 : c - 55;
            r += algorism << 4 * (hex.length() - 1 - i);
            --i;
        }
        return r;
    }

    public static String int2HexStr(int num) {
        return String.format("%x", num);
    }

    public static String formatSM2Signature(String cryptoText) {
        return cryptoText;
    }

    public static void main(String ... args) {
        System.out.println(Utils.int2HexStr(125));
        System.out.println(Utils.int2HexStr(125, 2));
        System.out.println(Utils.hexStr2Int(Utils.int2HexStr(125, 2)));
        System.out.println(Utils.hexStringToAlgorism(Utils.int2HexStr(125, 2)));
        int i = 0;
        while (i < 1000) {
            System.out.println(Utils.genRandomKey(16));
            ++i;
        }
        System.out.println("P=" + Utils.byteToHex(new BigInteger("442002041598310037376555260603321765732897688653730875009742903320409330978973").toByteArray()));
        System.out.println("A=" + Utils.byteToHex(new BigInteger("51818262926001898127292796913519728338822723149233462760049183264953289370042").toByteArray()));
        System.out.println("B=" + Utils.byteToHex(new BigInteger("-143107343669866435771844078991091842446828925100489630075496033418375917747581").toByteArray()));
        System.out.println("X=" + Utils.byteToHex(new BigInteger("-138041267157581764783510621457307987655817651576612939621174584327351733201130").toByteArray()));
        System.out.println("Y=" + Utils.byteToHex(new BigInteger("73275757665101991239261084847696608216695353070880671808616463092138370599577").toByteArray()));
        System.out.println("N=" + Utils.byteToHex(new BigInteger("187280914496245656232698815107523620446138827916468616838849621425626541022659").toByteArray()));
    }
}

