/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.old157.util;

import com.security.gm.old157.util.SM2Result;
import com.security.gm.old157.util.SM3Digest;
import com.security.gm.old157.util.StringUtil;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public class SM2 {
    public static String[] ecc_param = new String[]{"FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"};
    public final BigInteger ecc_p = new BigInteger(ecc_param[0], 16);
    public final BigInteger ecc_a = new BigInteger(ecc_param[1], 16);
    public final BigInteger ecc_b = new BigInteger(ecc_param[2], 16);
    public final BigInteger ecc_n = new BigInteger(ecc_param[3], 16);
    public final BigInteger ecc_gx = new BigInteger(ecc_param[4], 16);
    public final BigInteger ecc_gy = new BigInteger(ecc_param[5], 16);
    public final ECCurve ecc_curve = new ECCurve.Fp(this.ecc_p, this.ecc_a, this.ecc_b, this.ecc_n, ECConstants.ONE);
    public final ECPoint ecc_point_g = this.ecc_curve.createPoint(this.ecc_gx, this.ecc_gy);
    public final ECDomainParameters ecc_bc_spec = new ECDomainParameters(this.ecc_curve, this.ecc_point_g, this.ecc_n);
    public final ECKeyPairGenerator ecc_key_pair_generator;

    public static SM2 Instance() {
        return new SM2();
    }

    public SM2() {
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(this.ecc_bc_spec, new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
    }

    public byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        SM3Digest sm3 = new SM3Digest();
        int len = userId.length * 8;
        sm3.update((byte)(len >> 8 & 0xFF));
        sm3.update((byte)(len & 0xFF));
        sm3.update(userId, 0, userId.length);
        byte[] p = StringUtil.byteConvert32Bytes(this.ecc_a);
        sm3.update(p, 0, p.length);
        p = StringUtil.byteConvert32Bytes(this.ecc_b);
        sm3.update(p, 0, p.length);
        p = StringUtil.byteConvert32Bytes(this.ecc_gx);
        sm3.update(p, 0, p.length);
        p = StringUtil.byteConvert32Bytes(this.ecc_gy);
        sm3.update(p, 0, p.length);
        System.out.println(userKey.isNormalized());
        p = StringUtil.byteConvert32Bytes(userKey.normalize().getXCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        p = StringUtil.byteConvert32Bytes(userKey.normalize().getYCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    public void sm2Sign(byte[] md, BigInteger userD, ECPoint userKey, SM2Result sm2Result) {
        BigInteger e = new BigInteger(1, md);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        while (true) {
            AsymmetricCipherKeyPair keypair = this.ecc_key_pair_generator.generateKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
            k = ecpriv.getD();
            kp = ecpub.getQ();
            r = e.add(kp.getXCoord().toBigInteger());
            if ((r = r.mod(this.ecc_n)).equals(BigInteger.ZERO) || r.add(k).equals(this.ecc_n)) continue;
            BigInteger da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(this.ecc_n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(this.ecc_n);
            if (!(s = da_1.multiply(s).mod(this.ecc_n)).equals(BigInteger.ZERO)) break;
        }
        sm2Result.r = r;
        sm2Result.s = s;
    }

    public void sm2Verify(byte[] md, ECPoint userKey, BigInteger r, BigInteger s, SM2Result sm2Result) {
        sm2Result.R = null;
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(this.ecc_n);
        if (t.equals(BigInteger.ZERO)) {
            return;
        }
        ECPoint x1y1 = this.ecc_point_g.multiply(sm2Result.s);
        x1y1 = x1y1.add(userKey.multiply(t));
        sm2Result.R = e.add(x1y1.normalize().getXCoord().toBigInteger()).mod(this.ecc_n);
        System.out.println("R: " + sm2Result.R.toString(16));
    }

    public String fromXgetY(String ysPubKey) {
        if (ysPubKey.length() != 66) {
            return "9001";
        }
        if (!ysPubKey.substring(0, 2).equals("02") && !ysPubKey.substring(0, 2).equals("03")) {
            return "9002";
        }
        byte[] decode = StringUtil.hexStringToBytes(ysPubKey);
        ECPoint tmpPoint = this.ecc_curve.decodePoint(decode);
        ECFieldElement y = tmpPoint.getYCoord();
        String pubKeyY = y.toBigInteger().toString(16);
        return "9000" + StringUtil.addLeftZero(pubKeyY.toUpperCase(), 64);
    }

    public static void main(String[] arg) throws Exception {
        SM2 sm2 = new SM2();
        String ysPubKey = "03190ED75A556DFF2D30571F89A650F04F5629C3907114C7CC1E5F3F6225016F26";
        String y = sm2.fromXgetY(ysPubKey);
        System.out.println(y);
        AsymmetricCipherKeyPair keyPair2 = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keyPair2.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keyPair2.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        System.out.println("\u516c\u94a5 " + StringUtil.bytesToHexString(publicKey.getEncoded(true)));
        System.out.println("\u516c\u94a5\u975e\u538b\u7f29: " + StringUtil.bytesToHexString(publicKey.getEncoded(false)));
        System.out.println("\u79c1\u94a5: " + StringUtil.bytesToHexString(privateKey.toByteArray()));
    }
}

