/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.old157.util;

import com.security.gm.old157.util.Cipher;
import com.security.gm.old157.util.SM2;
import com.security.gm.old157.util.SM2Result;
import com.security.gm.old157.util.SM3Digest;
import com.security.gm.old157.util.StringUtil;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Utils {
    public static void generateKeyPair() {
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        System.out.println("\u516c\u94a5: " + StringUtil.bytesToHexString(publicKey.getEncoded(true)));
        System.out.println("\u975e\u538b\u7f29\u516c\u94a5: " + StringUtil.bytesToHexString(publicKey.getEncoded(false)));
        System.out.println("\u79c1\u94a5: " + StringUtil.bytesToHexString(privateKey.toByteArray()));
    }

    public static String encrypt(byte[] publicKey, byte[] data) throws IOException {
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);
        Cipher cipher = new Cipher();
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);
        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        return String.valueOf(StringUtil.bytesToHexString(c1.getEncoded(false))) + StringUtil.bytesToHexString(source) + StringUtil.bytesToHexString(c3);
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws IOException {
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        String data = StringUtil.bytesToHexString(encryptedData);
        byte[] c1Bytes = StringUtil.hexStringToBytes(data.substring(0, 130));
        int c2Len = encryptedData.length - 97;
        byte[] c2 = StringUtil.hexStringToBytes(data.substring(130, 130 + 2 * c2Len));
        byte[] c3 = StringUtil.hexStringToBytes(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPoint c1 = sm2.ecc_curve.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return c2;
    }

    public static byte[] sign(byte[] userId, byte[] privateKey, byte[] sourceData) throws IOException {
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (sourceData == null || sourceData.length == 0) {
            return null;
        }
        SM2 sm2 = SM2.Instance();
        byte[] privateKeyTemp = StringUtil.hexStringToBytes("00" + StringUtil.bytesToHexString(privateKey));
        BigInteger userD = new BigInteger(privateKeyTemp);
        ECPoint userKey = sm2.ecc_point_g.multiply(userD);
        SM3Digest sm3 = new SM3Digest();
        byte[] z = sm2.sm2GetZ(userId, userKey);
        sm3.update(z, 0, z.length);
        sm3.update(sourceData, 0, sourceData.length);
        byte[] md = new byte[32];
        sm3.doFinal(md, 0);
        SM2Result sm2Result = new SM2Result();
        sm2.sm2Sign(md, userD, userKey, sm2Result);
        String sign = String.valueOf(StringUtil.addLeftZero(sm2Result.r.toString(16), 64)) + StringUtil.addLeftZero(sm2Result.s.toString(16), 64);
        System.out.println("sign=" + sign);
        return StringUtil.hexStringToBytes(sign);
    }

    public static boolean verifySign(byte[] userId, byte[] publicKey, byte[] sourceData, byte[] signData) throws IOException {
        if (publicKey == null || publicKey.length == 0) {
            return false;
        }
        if (sourceData == null || sourceData.length == 0) {
            return false;
        }
        SM2 sm2 = SM2.Instance();
        ECPoint userKey = sm2.ecc_curve.decodePoint(publicKey);
        SM3Digest sm3 = new SM3Digest();
        byte[] z = sm2.sm2GetZ(userId, userKey);
        sm3.update(z, 0, z.length);
        sm3.update(sourceData, 0, sourceData.length);
        byte[] md = new byte[32];
        sm3.doFinal(md, 0);
        String signDataHex = StringUtil.bytesToHexString(signData);
        SM2Result sm2Result = new SM2Result();
        sm2Result.r = new BigInteger(signDataHex.substring(0, 64), 16);
        sm2Result.s = new BigInteger(signDataHex.substring(64, 128), 16);
        sm2.sm2Verify(md, userKey, sm2Result.r, sm2Result.s, sm2Result);
        return sm2Result.r.equals(sm2Result.R);
    }

    public static void main(String[] args) throws Exception {
        SM2 sm2 = SM2.Instance();
        AsymmetricCipherKeyPair key = sm2.ecc_key_pair_generator.generateKeyPair();
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
    }
}

