/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.old157.util;

import com.security.gm.old157.util.SM4;
import com.security.gm.old157.util.SM4_Context;
import com.security.gm.old157.util.StringUtil;
import java.io.IOException;

public class SM4Utils {
    public String secretKey = "";
    public String iv = "";
    public boolean hexString = false;

    public byte[] encryptData_ECB(byte[] plainByte) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? StringUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainByte);
            return encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decryptData_ECB(byte[] cipherByte) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? StringUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, cipherByte);
            return decrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] encryptData_CBC(byte[] plainByte) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = StringUtil.hexStringToBytes(this.secretKey);
                ivBytes = StringUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainByte);
            return encrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] decryptData_CBC(byte[] cipherByte) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = StringUtil.hexStringToBytes(this.secretKey);
                ivBytes = StringUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, cipherByte);
            return decrypted;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        String encode = "UTF-8";
        String plainText = "111111111111111122222222222222223333333333333333";
        byte[] plainByte = plainText.getBytes(encode);
        SM4Utils sm4 = new SM4Utils();
        sm4.secretKey = "31323334353637383930313233343536";
        sm4.hexString = true;
        System.out.println("hexkey=[" + sm4.secretKey + "]");
        System.out.println("ECB \u6a21\u5f0f\u52a0\u5bc6");
        byte[] cipherByte = sm4.encryptData_ECB(plainByte);
        System.out.println("\u5bc6\u6587: " + new String(cipherByte, encode));
        System.out.println("\u5bc6\u6587HEX: " + StringUtil.bytesToHexString(cipherByte));
        System.out.println("");
    }
}

