/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.other;

import com.security.gm.Utils;
import com.security.gm.other.KeyUtils;
import com.security.gm.other.SM2Utils;
import com.security.gm.other.SM3Utils;
import com.security.gm.other.SM4Utils;
import java.util.Random;

public class GmTest {
    public static void main(String[] args) throws Exception {
        String srcdata = "0123.-//*+213124+)()*(&1-z\u8fd9\u662f\u4e00\u6bb5\u6d4b\u8bd5\u6570\u636e\uff01dwq";
        byte[] SyncKey = GmTest.randomString(16).getBytes();
        byte[] CntrKey = SM4Utils.generateKey(128);
        System.out.println("SyncKey " + Utils.byteToHex(SyncKey));
        System.out.println();
        System.out.println("CntrKey " + Utils.byteToHex(CntrKey));
        System.out.println();
        String[] keys = KeyUtils.generateKey();
        System.out.println("\u79c1\u94a5\uff1a" + new String(keys[0]));
        System.out.println();
        System.out.println("\u516c\u94a5\uff1a" + new String(keys[1]));
        System.out.println();
        byte[] hash = SM3Utils.hash(srcdata.getBytes());
        System.out.println("\u6458\u8981\uff1a" + new String(Utils.byteToHex(hash)));
        System.out.println();
        byte[] signature = SM2Utils.signByPrivateKey(hash, KeyUtils.createPrivateKey(keys[0]));
        System.out.println("\u7b7e\u540d\uff1a " + new String(Utils.byteToHex(signature)));
        System.out.println();
        boolean result = SM2Utils.verifyByPublicKey(hash, KeyUtils.createPublicKey(keys[1]), signature);
        System.out.println("\u9a8c\u7b7e\u7ed3\u679c\uff1a " + result);
        System.out.println();
        byte[] sm2en = SM2Utils.encrypt(srcdata.getBytes(), KeyUtils.createPublicKey(keys[1]));
        System.out.println("SM2\u52a0\u5bc6\u540e\u62a5\u6587\uff1a" + new String(sm2en));
        System.out.println();
        byte[] sm2de = SM2Utils.decrypt(sm2en, KeyUtils.createPrivateKey(keys[0]));
        System.out.println("SM2\u89e3\u5bc6\u540e\u62a5\u6587 \uff1a" + new String(sm2de));
        System.out.println();
        System.out.println("SM2\u89e3\u5bc6\u7ed3\u679c\uff1a " + srcdata.equals(new String(sm2de)));
        System.out.println();
        System.out.println("SM4\u52a0\u5bc6\u539f\u59cb\u6570\u636e\uff1a " + new String(Utils.byteToHex(CntrKey)));
        System.out.println();
        byte[] sm4en = SM4Utils.encrypt_Ecb(CntrKey, SyncKey);
        System.out.println("SM4\u52a0\u5bc6\u540e\u6570\u636e\uff1a " + new String(Utils.byteToHex(sm4en)));
        System.out.println();
        byte[] sm4de = SM4Utils.decrypt_Ecb(sm4en, SyncKey);
        System.out.println("SM4\u89e3\u5bc6\u6570\u636e\uff1a " + new String(Utils.byteToHex(sm4de)));
    }

    public static String randomString(int length) {
        char[] charArr = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        char[] array = new char[length];
        Random random = new Random();
        int i = 0;
        while (i < length) {
            array[i] = charArr[random.nextInt(charArr.length)];
            ++i;
        }
        return String.copyValueOf(array);
    }
}

