/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.other;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public class SM4Utils {
    private static final String ENCODING = "UTF-8";
    public static final String ALGORITHM_NAME = "SM4";
    public static final String ALGORITHM_NAME_ECB_PADDING = "SM4/ECB/PKCS5Padding";
    public static final int DEFAULT_KEY_SIZE = 128;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static Cipher generateEcbCipher(String algorithmName, int mode, byte[] key) throws Exception {
        Cipher cipher = Cipher.getInstance(algorithmName, "BC");
        SecretKeySpec sm4Key = new SecretKeySpec(key, ALGORITHM_NAME);
        cipher.init(mode, sm4Key);
        return cipher;
    }

    public static byte[] generateKey() throws Exception {
        return SM4Utils.generateKey(128);
    }

    public static byte[] generateKey(int keySize) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance(ALGORITHM_NAME, "BC");
        kg.init(keySize, new SecureRandom());
        return kg.generateKey().getEncoded();
    }

    public static String encryptEcb(String hexKey, String paramStr) throws Exception {
        String cipherText = "";
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] srcData = paramStr.getBytes(ENCODING);
        byte[] cipherArray = SM4Utils.encrypt_Ecb(srcData, keyData);
        cipherText = ByteUtils.toHexString((byte[])cipherArray);
        return cipherText;
    }

    public static byte[] encrypt_Ecb(byte[] data, byte[] key) throws Exception {
        Cipher cipher = SM4Utils.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 1, key);
        return cipher.doFinal(data);
    }

    public static String decryptEcb(String hexKey, String cipherText) throws Exception {
        String decryptStr = "";
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] srcData = SM4Utils.decrypt_Ecb(cipherData, keyData);
        decryptStr = new String(srcData, ENCODING);
        return decryptStr;
    }

    public static byte[] decrypt_Ecb(byte[] cipherText, byte[] key) throws Exception {
        Cipher cipher = SM4Utils.generateEcbCipher(ALGORITHM_NAME_ECB_PADDING, 2, key);
        return cipher.doFinal(cipherText);
    }

    public static boolean verifyEcb(String hexKey, String cipherText, String paramStr) throws Exception {
        boolean flag = false;
        byte[] keyData = ByteUtils.fromHexString((String)hexKey);
        byte[] cipherData = ByteUtils.fromHexString((String)cipherText);
        byte[] decryptData = SM4Utils.decrypt_Ecb(cipherData, keyData);
        byte[] srcData = paramStr.getBytes(ENCODING);
        flag = Arrays.equals(decryptData, srcData);
        return flag;
    }
}

