/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.sm2;

import com.security.gm.Utils;
import com.security.gm.sm2.SM2KeyPair;
import com.security.gm.sm2.SM2KeyVO;
import com.security.gm.sm2.SM2Result;
import com.security.gm.sm2.SM2SignVO;
import com.security.gm.sm3.SM3Digest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.ShortenedDigest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Base64;

public class SM2Util {
    private static String USER_ID = "1234567812345678";
    private static final BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static final BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static final BigInteger xg = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static final BigInteger yg = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static final BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static SecureRandom random = new SecureRandom();
    private ECCurve curve = new ECCurve.Fp(p, a, b, n, ECConstants.ONE);
    private ECPoint G = this.curve.createPoint(xg, yg);
    private static final int DIGEST_LENGTH = 20;
    public final ECKeyPairGenerator ecc_key_pair_generator;
    private static SM2Util instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SM2Util getInstance() {
        if (instance != null) return instance;
        Class<SM2Util> clazz = SM2Util.class;
        synchronized (SM2Util.class) {
            if (instance != null) return instance;
            instance = new SM2Util();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private byte[] sm2GetZ(byte[] userId, ECPoint userKey) {
        SM3Digest sm3 = new SM3Digest();
        int len = userId.length * 8;
        sm3.update((byte)(len >> 8 & 0xFF));
        sm3.update((byte)(len & 0xFF));
        sm3.update(userId, 0, userId.length);
        byte[] p = a.toByteArray();
        sm3.update(p, 0, p.length);
        p = b.toByteArray();
        sm3.update(p, 0, p.length);
        p = xg.toByteArray();
        sm3.update(p, 0, p.length);
        p = yg.toByteArray();
        sm3.update(p, 0, p.length);
        p = Utils.byteConvert32Bytes(userKey.normalize().getXCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        p = Utils.byteConvert32Bytes(userKey.normalize().getYCoord().toBigInteger());
        sm3.update(p, 0, p.length);
        byte[] md = new byte[sm3.getDigestSize()];
        sm3.doFinal(md, 0);
        return md;
    }

    private static String toBase64Str(byte[] b) {
        return new String(Base64.encode((byte[])b), Charset.forName("UTF-8"));
    }

    private static byte[] toByteArray(String encryptMsg) {
        return Base64.decode((byte[])encryptMsg.getBytes(Charset.forName("UTF-8")));
    }

    public BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private boolean allZero(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String encrypt(String input, ECPoint publicKey) throws Exception {
        byte[] C1Buffer;
        BigInteger k;
        ECPoint kpb;
        byte[] kpbBytes;
        byte[] t;
        byte[] inputBuffer = input.getBytes("UTF-8");
        do {
            ECPoint result;
            k = this.random(n);
            ECPoint C1 = this.G.multiply(k);
            C1Buffer = C1.getEncoded(false);
            BigInteger h = this.curve.getCofactor();
            if (publicKey == null || !(result = publicKey.multiply(h)).isInfinity()) continue;
            throw new Exception("\u52a0\u5bc6\u5931\u8d25!!--\u8ba1\u7b97\u692d\u5706\u66f2\u7ebf\u70b9 S = [h]Pb\u5931\u8d25");
        } while (this.allZero(t = SM2Util.KDF(kpbBytes = (kpb = publicKey.multiply(k).normalize()).getEncoded(false), inputBuffer.length)));
        byte[] C2 = new byte[inputBuffer.length];
        int i = 0;
        while (i < inputBuffer.length) {
            C2[i] = (byte)(inputBuffer[i] ^ t[i]);
            ++i;
        }
        byte[] C3 = this.calculateHash(kpb.getXCoord().toBigInteger(), inputBuffer, kpb.getYCoord().toBigInteger());
        byte[] encryptResult = new byte[C1Buffer.length + C2.length + C3.length];
        System.arraycopy(C1Buffer, 0, encryptResult, 0, C1Buffer.length);
        System.arraycopy(C2, 0, encryptResult, C1Buffer.length, C2.length);
        System.arraycopy(C3, 0, encryptResult, C1Buffer.length + C2.length, C3.length);
        return SM2Util.toBase64Str(encryptResult);
    }

    public static byte[] KDF(byte[] Z, int klen) throws Exception {
        int ct = 1;
        int end = (int)Math.ceil((double)klen * 1.0 / 32.0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 1;
        while (i <= end) {
            baos.write(SM2Util.sm3Hash(Z, Utils.intToBytes(ct)));
            ++ct;
            ++i;
        }
        byte[] last = SM2Util.sm3Hash(Z, Utils.intToBytes(ct));
        if (klen % 32 == 0) {
            baos.write(last);
        } else {
            baos.write(last, 0, klen % 32);
        }
        return baos.toByteArray();
    }

    private static byte[] sm3Hash(byte[] ... params) throws Exception {
        return new SM3Digest().hash(Utils.joinBytes(params));
    }

    public String decrypt(String encryptMsg, BigInteger privateKey) throws Exception {
        return this.decrypt(SM2Util.toByteArray(encryptMsg), privateKey);
    }

    private String decrypt(byte[] encryptData, BigInteger privateKey) throws Exception {
        byte[] C1Byte = new byte[65];
        System.arraycopy(encryptData, 0, C1Byte, 0, C1Byte.length);
        ECPoint C1 = this.curve.decodePoint(C1Byte).normalize();
        ECPoint dBC1 = C1.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        int klen = encryptData.length - 65 - 20;
        byte[] t = SM2Util.KDF(dBC1Bytes, klen);
        if (this.allZero(t)) {
            throw new IllegalStateException("all zero. \u89e3\u5bc6\u5f02\u5e38!!!");
        }
        byte[] M = new byte[klen];
        int i = 0;
        while (i < M.length) {
            M[i] = (byte)(encryptData[C1Byte.length + i] ^ t[i]);
            ++i;
        }
        byte[] C3 = new byte[20];
        System.arraycopy(encryptData, encryptData.length - 20, C3, 0, 20);
        byte[] u = this.calculateHash(dBC1.getXCoord().toBigInteger(), M, dBC1.getYCoord().toBigInteger());
        if (Arrays.equals(u, C3)) {
            String dMsg = new String(M, Charset.forName("UTF-8"));
            return dMsg;
        }
        throw new Exception("\u89e3\u5bc6\u5931\u8d25!!");
    }

    private byte[] calculateHash(BigInteger x2, byte[] M, BigInteger y2) {
        ShortenedDigest digest = new ShortenedDigest((ExtendedDigest)new SHA256Digest(), 20);
        byte[] buf = x2.toByteArray();
        digest.update(buf, 0, buf.length);
        digest.update(M, 0, M.length);
        buf = y2.toByteArray();
        digest.update(buf, 0, buf.length);
        buf = new byte[20];
        digest.doFinal(buf, 0);
        return buf;
    }

    private boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (this.between(x, new BigInteger("0"), p) && this.between(y, new BigInteger("0"), p)) {
                BigInteger xResult = x.pow(3).add(a.multiply(x)).add(b).mod(p);
                BigInteger yResult = y.pow(2).mod(p);
                if (yResult.equals(xResult) && publicKey.multiply(n).isInfinity()) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public SM2KeyPair generateKeyPair() throws Exception {
        BigInteger d = this.random(n.subtract(new BigInteger("1")));
        SM2KeyPair keyPair = new SM2KeyPair(this.G.multiply(d).normalize(), d);
        if (this.checkPublicKey(keyPair.getPublicKey())) {
            return keyPair;
        }
        throw new Exception("\u751f\u6210\u5bc6\u94a5\u5bf9\u51fa\u9519!!");
    }

    public SM2KeyVO generateKeyPairVO() {
        AsymmetricCipherKeyPair key = null;
        while (((ECPrivateKeyParameters)(key = this.ecc_key_pair_generator.generateKeyPair()).getPrivate()).getD().toByteArray().length != 32) {
        }
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        SM2KeyVO sm2KeyVO = new SM2KeyVO();
        sm2KeyVO.setPublicKey(publicKey);
        sm2KeyVO.setPrivateKey(privateKey);
        return sm2KeyVO;
    }

    private SM2Util() {
        ECKeyGenerationParameters ecc_ecgenparam = new ECKeyGenerationParameters(new ECDomainParameters(this.curve, this.G, n), new SecureRandom());
        this.ecc_key_pair_generator = new ECKeyPairGenerator();
        this.ecc_key_pair_generator.init((KeyGenerationParameters)ecc_ecgenparam);
    }

    public ECPoint getPublicKeyByPrivateKey(BigInteger privateKey) {
        return this.G.multiply(privateKey).normalize();
    }

    public ECPoint decodePubKey(byte[] pubKeyArr) {
        return this.curve.decodePoint(pubKeyArr);
    }

    public SM2SignVO sign(byte[] privatekey, byte[] sourceData) throws Exception {
        SM2SignVO sm2SignVO = new SM2SignVO();
        sm2SignVO.setSm2_type("sign");
        BigInteger userD = new BigInteger(privatekey);
        sm2SignVO.setSm2_userd(userD.toString(16));
        ECPoint userKey = this.G.multiply(userD);
        SM3Digest sm3Digest = new SM3Digest();
        byte[] z = this.sm2GetZ(USER_ID.getBytes("UTF-8"), userKey);
        sm2SignVO.setSm3_z(Utils.getHexString(z));
        sm2SignVO.setSign_express(Utils.getHexString(sourceData));
        sm3Digest.update(z, 0, z.length);
        sm3Digest.update(sourceData, 0, sourceData.length);
        byte[] md = new byte[32];
        sm3Digest.doFinal(md, 0);
        sm2SignVO.setSm3_digest(Utils.getHexString(md));
        SM2Result sm2Result = new SM2Result();
        this.sm2Sign(md, userD, userKey, sm2Result);
        sm2SignVO.setSign_r(sm2Result.r.toString(16));
        sm2SignVO.setSign_s(sm2Result.s.toString(16));
        ASN1Integer d_r = new ASN1Integer(sm2Result.r);
        ASN1Integer d_s = new ASN1Integer(sm2Result.s);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add((ASN1Encodable)d_r);
        v2.add((ASN1Encodable)d_s);
        DERSequence sign = new DERSequence(v2);
        String result = Utils.byteToHex(sign.getEncoded());
        sm2SignVO.setSm2_sign(result);
        return sm2SignVO;
    }

    public byte[] sign2(byte[] privatekey, byte[] sourceData) throws IOException {
        SM2SignVO sm2SignVO = new SM2SignVO();
        sm2SignVO.setSm2_type("sign");
        BigInteger userD = new BigInteger(privatekey);
        sm2SignVO.setSm2_userd(userD.toString(16));
        ECPoint userKey = this.G.multiply(userD);
        SM3Digest sm3Digest = new SM3Digest();
        byte[] z = this.sm2GetZ(USER_ID.getBytes("UTF-8"), userKey);
        sm2SignVO.setSm3_z(Utils.getHexString(z));
        sm2SignVO.setSign_express(Utils.getHexString(sourceData));
        sm3Digest.update(z, 0, z.length);
        sm3Digest.update(sourceData, 0, sourceData.length);
        byte[] md = new byte[32];
        sm3Digest.doFinal(md, 0);
        sm2SignVO.setSm3_digest(Utils.getHexString(md));
        SM2Result sm2Result = new SM2Result();
        this.sm2Sign(md, userD, userKey, sm2Result);
        String sign = String.valueOf(SM2Util.addLeftZero(sm2Result.r.toString(16), 64)) + SM2Util.addLeftZero(sm2Result.s.toString(16), 64);
        return Utils.hexStringToBytes(sign);
    }

    public static String addLeftZero(String str, int length) {
        if (str == null) {
            str = "";
        }
        int str_length = str.length();
        int i = 0;
        while (i < length - str_length) {
            str = String.valueOf('0') + str;
            ++i;
        }
        return str;
    }

    private void sm2Sign(byte[] md, BigInteger userD, ECPoint userKey, SM2Result sm2Result) {
        BigInteger e = new BigInteger(1, md);
        BigInteger k = null;
        ECPoint kp = null;
        BigInteger r = null;
        BigInteger s = null;
        while (true) {
            AsymmetricCipherKeyPair keypair = this.ecc_key_pair_generator.generateKeyPair();
            ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)keypair.getPrivate();
            ECPublicKeyParameters ecpub = (ECPublicKeyParameters)keypair.getPublic();
            k = ecpriv.getD();
            kp = ecpub.getQ();
            r = e.add(kp.getXCoord().toBigInteger());
            if ((r = r.mod(n)).equals(BigInteger.ZERO) || r.add(k).equals(n) || r.toString(16).length() != 64) continue;
            BigInteger da_1 = userD.add(BigInteger.ONE);
            da_1 = da_1.modInverse(n);
            s = r.multiply(userD);
            s = k.subtract(s).mod(n);
            if (!(s = da_1.multiply(s).mod(n)).equals(BigInteger.ZERO) && s.toString(16).length() == 64) break;
        }
        sm2Result.r = r;
        sm2Result.s = s;
    }

    public SM2SignVO signVerify(byte[] publicKey, byte[] sourceData, byte[] signData) throws Exception {
        ASN1InputStream dis = null;
        try {
            byte[] formatedPubKey;
            SM2SignVO verifyVo = new SM2SignVO();
            verifyVo.setSm2_type("verify");
            if (publicKey.length == 64) {
                formatedPubKey = new byte[65];
                formatedPubKey[0] = 4;
                System.arraycopy(publicKey, 0, formatedPubKey, 1, publicKey.length);
            } else {
                formatedPubKey = publicKey;
            }
            ECPoint userKey = this.curve.decodePoint(formatedPubKey);
            SM3Digest sm3Digest = new SM3Digest();
            byte[] z = this.sm2GetZ(USER_ID.getBytes("UTF-8"), userKey);
            verifyVo.setSm3_z(Utils.getHexString(z));
            sm3Digest.update(z, 0, z.length);
            sm3Digest.update(sourceData, 0, sourceData.length);
            byte[] md = new byte[32];
            sm3Digest.doFinal(md, 0);
            verifyVo.setSm3_digest(Utils.getHexString(md));
            ByteArrayInputStream bis = new ByteArrayInputStream(signData);
            dis = new ASN1InputStream((InputStream)bis);
            SM2Result sm2Result = new SM2Result();
            ASN1Primitive derObj = dis.readObject();
            Enumeration e = ((ASN1Sequence)derObj).getObjects();
            BigInteger r = ((ASN1Integer)e.nextElement()).getValue();
            BigInteger s = ((ASN1Integer)e.nextElement()).getValue();
            sm2Result.r = r;
            sm2Result.s = s;
            verifyVo.setVerify_r(sm2Result.r.toString(16));
            verifyVo.setVerify_s(sm2Result.s.toString(16));
            this.sm2Verify(md, userKey, sm2Result.r, sm2Result.s, sm2Result);
            boolean verifyFlag = sm2Result.r.equals(sm2Result.R);
            verifyVo.setVerify(verifyFlag);
            SM2SignVO sM2SignVO = verifyVo;
            return sM2SignVO;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    private void sm2Verify(byte[] md, ECPoint userKey, BigInteger r, BigInteger s, SM2Result sm2Result) {
        sm2Result.R = null;
        BigInteger e = new BigInteger(1, md);
        BigInteger t = r.add(s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return;
        }
        ECPoint x1y1 = this.G.multiply(sm2Result.s);
        x1y1 = x1y1.add(userKey.multiply(t));
        sm2Result.R = e.add(x1y1.normalize().getXCoord().toBigInteger()).mod(n);
    }

    public ECCurve getCurve() {
        return this.curve;
    }
}

