/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.sm2;

import com.security.gm.Utils;
import com.security.gm.sm2.SM2KeyPair;
import com.security.gm.sm2.SM2KeyVO;
import com.security.gm.sm2.SM2SignVO;
import com.security.gm.sm2.SM2Util;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;

public class SM2UtilTest {
    static String M = "this is a testdfas\u963f\u65af\u8482\u82ac\u5361\u5566\u8fd8\u662f\u4e1c\u65b9\u53ef@#%^&*()&*()!@#$<M>KL:\\\\\\\\\\\\\\\"?:{}{P|ZXF~!@~!@\u62c9\u4f38\u7684\u53d1\u751f\u7684\u5496\u5561\u673a\u54c8\u5e08\u5927\u5f00\u53d1\u548cdf";
    private static String PRIVATE_KEY_STR;
    private static String PUBLIC_KEY_STR;

    public static void main(String[] args) throws Exception {
        SM2UtilTest.generateKeyPair();
    }

    public static void encryptAndDecryptTest() throws Exception {
        System.out.println("\u52a0\u5bc6\u524d\u6d88\u606f:" + M);
        BigInteger privateKey = new BigInteger(Utils.hexStringToBytes(PRIVATE_KEY_STR));
        ECPoint publicKey = SM2Util.getInstance().decodePubKey(Utils.hexStringToBytes(PUBLIC_KEY_STR));
        String eMsg = SM2Util.getInstance().encrypt(M, publicKey);
        System.out.println("\u52a0\u5bc6\u540e\u6d88\u606f:" + eMsg);
        eMsg = SM2Util.getInstance().decrypt(eMsg, privateKey);
        System.out.println("\u89e3\u5bc6\u540e\u6d88\u606f:" + eMsg);
        SM2SignVO sign = SM2Util.getInstance().sign(privateKey.toByteArray(), M.getBytes());
        System.out.println("\u7b7e\u540d\u5f97\u5230\u7684r\u503c:" + sign.getSign_r() + "\n\u7b7e\u540d\u503c " + sign.getSm2_signForSoft());
        SM2SignVO verify = SM2Util.getInstance().signVerify(publicKey.getEncoded(true), M.getBytes(), Utils.hexStringToBytes(sign.getSm2_signForSoft()));
        System.out.println("\u9a8c\u7b7e\u5f97\u5230\u7684R\u503c:" + verify.getVerify_r());
        System.err.println("\u9a8c\u7b7e\u7ed3\u679c" + verify.isVerify());
    }

    public static void generateKeyPair() throws Exception {
        SM2KeyPair keyPair = SM2Util.getInstance().generateKeyPair();
        PRIVATE_KEY_STR = Utils.byteToHex(keyPair.getPrivateKey().toByteArray());
        PUBLIC_KEY_STR = Utils.byteToHex(keyPair.getPublicKey().getEncoded(false));
        System.out.println("\u79c1\u94a50\uff1a" + PRIVATE_KEY_STR);
        System.out.println("\u516c\u94a50\uff1a" + PUBLIC_KEY_STR + "\n");
        SM2KeyVO keyVO = SM2Util.getInstance().generateKeyPairVO();
        PRIVATE_KEY_STR = keyVO.getPriHexInSoft();
        PUBLIC_KEY_STR = keyVO.getPubHexInSoft(true);
    }
}

