/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.sm2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.security.gm.Context;
import com.security.gm.Utils;
import com.security.gm.sm2.SM2SignVO;
import com.security.gm.sm2.SM2Util;
import com.security.gm.sm4.SM4Utils;
import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECPoint;

public class SMSignDemo {
    private static final String qudaoPubkey = "03F23FC3DB49882846542B03D7762ABBCD5ADD4E19BA43CF44E47C4F4F24347992";
    private static final String qudaoPrikey = "35A9401EE28909C4CC52D197D89E2D6FA8C604CCF287F67C63BBAE6899EADB71";
    private static final String ZBPubkey = "02736CA1AD73A6EDB60169BFED1C3E626070C03AE3B4920DAB3ADF5B4DB6106E58";
    private static final String ZBPrikey = "1E823EBA9EB8E4E2BD4336DC615D5C9C30B08E1E9A619B9673CC180C9BE47E06";
    private static final BigInteger qudaoPrivateKey = new BigInteger(Utils.hexStringToBytes("35A9401EE28909C4CC52D197D89E2D6FA8C604CCF287F67C63BBAE6899EADB71"));
    private static final ECPoint ZBPublicKey = SM2Util.getInstance().decodePubKey(Utils.hexStringToBytes("02736CA1AD73A6EDB60169BFED1C3E626070C03AE3B4920DAB3ADF5B4DB6106E58"));
    private static final SM4Utils sm4 = new SM4Utils();

    public static void main(String[] args) {
        try {
            SMSignDemo.SmEnCryptMethod(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String SmEnCryptMethod(Context ctx) throws Exception {
        JSONObject reqJson = ctx.getRequestData();
        JSONObject data = reqJson.getJSONObject("request");
        String jsonSort = JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        System.err.println("\u52a0\u5bc6\u524d\u62a5\u6587\uff1a" + jsonSort);
        SM2SignVO signObj = SM2Util.getInstance().sign(qudaoPrivateKey.toByteArray(), jsonSort.getBytes());
        data.put("sign", (Object)signObj.getSm2_signForSoft());
        SMSignDemo.sm4.secretKey = ctx.getAeskey();
        String encryReq = sm4.encryptData_CBC(data.toJSONString());
        String encryKey = SM2Util.getInstance().encrypt(ctx.getAeskey(), ZBPublicKey);
        reqJson.put("request", (Object)encryReq);
        reqJson.put("aeskey", (Object)encryKey);
        ctx.setRequestData(reqJson);
        return reqJson.toJSONString();
    }

    public static String SmDecryptMethod(Context ctx) throws Exception {
        JSONObject json = ctx.getResponseData();
        System.err.println("\u89e3\u5bc6\u524d\u62a5\u6587\uff1a" + json);
        if (json.getString("JDEncryStatus") != null && "Y".equals(json.getString("JDEncryStatus"))) {
            JSONObject jdjson = JSONObject.parseObject((String)json.getString("JDEncry"));
            ctx.setResponseData(jdjson);
            return json.getString("JDEncry");
        }
        String dataKey = "result";
        SMSignDemo.sm4.secretKey = ctx.getAeskey();
        String decryResult = sm4.decryptData_CBC(json.getString(dataKey));
        System.out.println("\u89e3\u5bc6\u540e\u62a5\u6587\uff1a" + decryResult);
        json.put(dataKey, (Object)decryResult);
        String signRst = (String)json.getJSONObject(decryResult).remove((Object)"sign");
        String jsonSort = JSON.toJSONString((Object)json.getJSONObject(dataKey), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.MapSortField});
        SM2SignVO sign = SM2Util.getInstance().sign(qudaoPrivateKey.toByteArray(), jsonSort.getBytes());
        String signCheck = sign.getSm2_signForSoft();
        if (!signCheck.equals(signRst)) {
            throw new Exception("SM2\u9a8c\u7b7e\u5931\u8d25!");
        }
        System.out.println("SM2\u9a8c\u7b7e\u6210\u529f!");
        ctx.setResponseData(json);
        return json.toJSONString();
    }

    public static String getRandomKey() {
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        int i = 0;
        while (i < 32) {
            sb.append("1234567890QWERTYUIOPASDFGHJKLZXCVBNM".charAt(random.nextInt("1234567890QWERTYUIOPASDFGHJKLZXCVBNM".length())));
            ++i;
        }
        return sb.toString();
    }
}

