/*
 * Decompiled with CFR 0.152.
 */
package com.security.gm.sm2.cipher;

import com.security.gm.Utils;
import com.security.gm.sm2.SM2KeyVO;
import com.security.gm.sm2.SM2Util;
import com.security.gm.sm2.cipher.Cipher;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;

public class SM2EncDecUtils {
    public static SM2KeyVO generateKeyPair() {
        SM2Util sm2 = SM2Util.getInstance();
        AsymmetricCipherKeyPair key = null;
        while (((ECPrivateKeyParameters)(key = sm2.ecc_key_pair_generator.generateKeyPair()).getPrivate()).getD().toByteArray().length != 32) {
        }
        ECPrivateKeyParameters ecpriv = (ECPrivateKeyParameters)key.getPrivate();
        ECPublicKeyParameters ecpub = (ECPublicKeyParameters)key.getPublic();
        BigInteger privateKey = ecpriv.getD();
        ECPoint publicKey = ecpub.getQ();
        SM2KeyVO sm2KeyVO = new SM2KeyVO();
        sm2KeyVO.setPublicKey(publicKey);
        sm2KeyVO.setPrivateKey(privateKey);
        return sm2KeyVO;
    }

    public static String encrypt(byte[] publicKey, byte[] data) throws IOException {
        if (publicKey == null || publicKey.length == 0) {
            return null;
        }
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] source = new byte[data.length];
        System.arraycopy(data, 0, source, 0, data.length);
        Cipher cipher = new Cipher();
        SM2Util sm2 = SM2Util.getInstance();
        ECPoint userKey = sm2.getCurve().decodePoint(publicKey);
        ECPoint c1 = cipher.Init_enc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        return String.valueOf(Utils.byteToHex(c1.getEncoded(false))) + Utils.byteToHex(c3) + Utils.byteToHex(source);
    }

    public static byte[] decrypt(byte[] privateKey, byte[] encryptedData) throws IOException {
        if (privateKey == null || privateKey.length == 0) {
            return null;
        }
        if (encryptedData == null || encryptedData.length == 0) {
            return null;
        }
        String data = Utils.byteToHex(encryptedData);
        byte[] c1Bytes = Utils.hexToByte(data.substring(0, 130));
        int c2Len = encryptedData.length - 97;
        byte[] c3 = Utils.hexToByte(data.substring(130, 194));
        byte[] c2 = Utils.hexToByte(data.substring(194, 194 + 2 * c2Len));
        SM2Util sm2 = SM2Util.getInstance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPoint c1 = sm2.getCurve().decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.Init_dec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        return c2;
    }

    public static void main(String[] args) throws Exception {
        String privatekey;
        String plainText = "ILoveYou11";
        byte[] sourceData = plainText.getBytes();
        SM2EncDecUtils.generateKeyPair();
        String prik = "78BCCC21821CA8EF7791F5673B0F0A06C477EFF79D019C5F0113F6E5864D0678";
        String pubk = "04C69DA8698F7273674B4B89BF4B8A03E3E7AA02BA062BA4A7D8221BC483C505B2AE900B8245E9FD07ECFB50ACC29216FE563A6F396D52D56AA5D4FD11742C7550";
        String publicKey = "04BB34D657EE7E8490E66EF577E6B3CEA28B739511E787FB4F71B7F38F241D87F18A5A93DF74E90FF94F4EB907F271A36B295B851F971DA5418F4915E2C1A23D6E";
        prik = privatekey = "0B1CE43098BC21B8E82B5C065EDB534CB86532B1900A49D49F3C53762D2997FA";
        pubk = publicKey;
        System.out.println("\u52a0\u5bc6: ");
        String cipherText = SM2EncDecUtils.encrypt(Utils.hexToByte(pubk), sourceData);
        System.out.println(cipherText);
        System.out.println("\u89e3\u5bc6: ");
        plainText = new String(SM2EncDecUtils.decrypt(Utils.hexToByte(prik), Utils.hexToByte(cipherText)));
        System.out.println(plainText);
    }
}

